/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.user;

import ch.admin.bit.jeap.security.resource.authentication.ServletSimpleAuthorization;
import ch.admin.bit.jeap.security.resource.semanticAuthentication.ServletSemanticAuthorization;
import ch.admin.bit.jeap.security.user.JeapCurrentUser;
import ch.admin.bit.jeap.security.user.JeapCurrentUserMapper;
import java.util.Optional;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${jeap.security.oauth2.current-user-endpoint.path:/api/current-user}"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class JeapCurrentUserController {
    private final JeapCurrentUserMapper jeapCurrentUserMapper;
    private final Optional<ServletSemanticAuthorization> semanticAuthorization;
    private final Optional<ServletSimpleAuthorization> simpleAuthorization;

    @GetMapping
    public JeapCurrentUser getCurrentUser() {
        if (this.semanticAuthorization.isPresent()) {
            return this.jeapCurrentUserMapper.mapCurrentUser(this.semanticAuthorization.get().getAuthenticationToken());
        }
        if (this.simpleAuthorization.isPresent()) {
            return this.jeapCurrentUserMapper.mapCurrentUser(this.simpleAuthorization.get().getJeapAuthenticationToken());
        }
        throw new IllegalStateException("Cannot determine the current authentication: No ServletSemanticAuthorization or ServletSimpleAuthorization available");
    }

    @Generated
    public JeapCurrentUserController(JeapCurrentUserMapper jeapCurrentUserMapper, Optional<ServletSemanticAuthorization> semanticAuthorization, Optional<ServletSimpleAuthorization> simpleAuthorization) {
        this.jeapCurrentUserMapper = jeapCurrentUserMapper;
        this.semanticAuthorization = semanticAuthorization;
        this.simpleAuthorization = simpleAuthorization;
    }
}

