/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.validation;

import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;

public class AudienceJwtValidator
implements OAuth2TokenValidator<Jwt> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AudienceJwtValidator.class);
    private final String audience;
    private final OAuth2Error error;

    public AudienceJwtValidator(String audience) {
        this.audience = audience;
        this.error = new OAuth2Error("invalid_token", "The token is is not valid for audience '" + audience + "'.", null);
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        if (JeapAuthenticationContext.isB2B(jwt)) {
            return OAuth2TokenValidatorResult.success();
        }
        if (jwt.getAudience() == null || jwt.getAudience().isEmpty()) {
            return OAuth2TokenValidatorResult.success();
        }
        if (jwt.getAudience().contains(this.audience)) {
            return OAuth2TokenValidatorResult.success();
        }
        log.warn(this.error.getDescription());
        return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{this.error});
    }
}

