/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.resource.introspection;

import ch.admin.bit.jeap.security.resource.introspection.JeapIntrospectionInvalidTokenException;
import ch.admin.bit.jeap.security.resource.introspection.JeapTokenIntrospector;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.security.oauth2.jwt.Jwt;

class JeapTokenIntrospectionMetrics {
    private static final String METRIC_INTROSPECTION = "jeap.security.token.introspection";
    private static final String METRIC_INTROSPECTION_CONDITIONAL_INTROSPECTIONS = "jeap.security.token.introspection.conditional.introspections";
    private static final String METRIC_INTROSPECTION_VALIDITY_CHECKS = "jeap.security.token.introspection.validity.checks";
    private static final String METRIC_INTROSPECTION_REQUESTS = "jeap.security.token.introspection.endpoint.requests";
    private static final String TAG_ISSUER = "issuer";
    private static final String TAG_ACTIVE = "active";
    private static final String TAG_INTROSPECTED = "introspected";
    private static final String VALUE_UNKNOWN = "unknown";
    private final Optional<MeterRegistry> meterRegistry;

    void recordConditionalTokenIntrospection(Jwt jwt, boolean introspected, Boolean active) {
        this.meterRegistry.ifPresent(registry -> registry.counter(METRIC_INTROSPECTION_CONDITIONAL_INTROSPECTIONS, new String[]{TAG_ISSUER, JeapTokenIntrospectionMetrics.getIssuer(jwt), TAG_INTROSPECTED, Boolean.toString(introspected), TAG_ACTIVE, active != null ? active.toString() : VALUE_UNKNOWN}).increment());
    }

    void recordValidityCheck(Jwt jwt, boolean active) {
        this.meterRegistry.ifPresent(registry -> registry.counter(METRIC_INTROSPECTION_VALIDITY_CHECKS, new String[]{TAG_ISSUER, JeapTokenIntrospectionMetrics.getIssuer(jwt), TAG_ACTIVE, Boolean.toString(active)}).increment());
    }

    JeapTokenIntrospector timeTokenIntrospectionRequests(JeapTokenIntrospector tokenIntrospector, String issuer) {
        if (this.meterRegistry.isPresent()) {
            return token -> {
                Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry.get());
                try {
                    Map<String, Object> attributes = tokenIntrospector.introspect(token);
                    this.stopIntrospectionRequestTimer(sample, issuer, true);
                    return attributes;
                }
                catch (JeapIntrospectionInvalidTokenException tie) {
                    this.stopIntrospectionRequestTimer(sample, issuer, false);
                    throw tie;
                }
                catch (Exception e) {
                    this.stopIntrospectionRequestTimer(sample, issuer, null);
                    throw e;
                }
            };
        }
        return tokenIntrospector;
    }

    private void stopIntrospectionRequestTimer(Timer.Sample sample, String issuer, Boolean active) {
        this.meterRegistry.ifPresent(registry -> {
            Timer timer = Timer.builder((String)METRIC_INTROSPECTION_REQUESTS).tags(new String[]{TAG_ISSUER, issuer, TAG_ACTIVE, active != null ? active.toString() : VALUE_UNKNOWN}).publishPercentiles(new double[]{0.5, 0.75, 0.9, 0.99}).register(registry);
            sample.stop(timer);
        });
    }

    private static String getIssuer(Jwt jwt) {
        return jwt.getIssuer() != null ? jwt.getIssuer().toString() : VALUE_UNKNOWN;
    }

    @Generated
    public JeapTokenIntrospectionMetrics(Optional<MeterRegistry> meterRegistry) {
        this.meterRegistry = meterRegistry;
    }
}

