/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.security.user;

import ch.admin.bit.jeap.security.resource.authentication.ReactiveSimpleAuthorization;
import ch.admin.bit.jeap.security.resource.semanticAuthentication.ReactiveSemanticAuthorization;
import ch.admin.bit.jeap.security.user.JeapCurrentUser;
import ch.admin.bit.jeap.security.user.JeapCurrentUserMapper;
import java.util.Optional;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"${jeap.security.oauth2.current-user-endpoint.path:/api/current-user}"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class JeapCurrentUserWebFluxController {
    private final JeapCurrentUserMapper jeapCurrentUserMapper;
    private final Optional<ReactiveSemanticAuthorization> semanticAuthorization;
    private final Optional<ReactiveSimpleAuthorization> simpleAuthorization;

    @GetMapping
    public Mono<JeapCurrentUser> getCurrentUser() {
        if (this.semanticAuthorization.isPresent()) {
            return this.semanticAuthorization.get().getAuthenticationToken().map(this.jeapCurrentUserMapper::mapCurrentUser);
        }
        if (this.simpleAuthorization.isPresent()) {
            return this.simpleAuthorization.get().getJeapAuthenticationToken().map(this.jeapCurrentUserMapper::mapCurrentUser);
        }
        throw new IllegalStateException("Cannot determine the current authentication: No ReactiveSemanticAuthorization or ReactiveSimpleAuthorization available");
    }

    @Generated
    public JeapCurrentUserWebFluxController(JeapCurrentUserMapper jeapCurrentUserMapper, Optional<ReactiveSemanticAuthorization> semanticAuthorization, Optional<ReactiveSimpleAuthorization> simpleAuthorization) {
        this.jeapCurrentUserMapper = jeapCurrentUserMapper;
        this.semanticAuthorization = semanticAuthorization;
        this.simpleAuthorization = simpleAuthorization;
    }
}

