/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.swagger;

import java.net.MalformedURLException;
import java.net.URL;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.ServerBaseUrlCustomizer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpRequest;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnProperty(name={"jeap.swagger.enforceServerBaseHttps"}, matchIfMissing=true, havingValue="true")
public class HttpsServerBaseUrlConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpsServerBaseUrlConfiguration.class);

    @Bean
    HttpsEnforcerServerBaseUrlCustomizer httpsEnforcerServerBaseUrlCustomizer() {
        return new HttpsEnforcerServerBaseUrlCustomizer();
    }

    static class HttpsEnforcerServerBaseUrlCustomizer
    implements ServerBaseUrlCustomizer {
        HttpsEnforcerServerBaseUrlCustomizer() {
        }

        public String customize(String serverBaseUrl, HttpRequest request) {
            try {
                URL url;
                if (StringUtils.hasText((String)serverBaseUrl) && (url = new URL(serverBaseUrl)).getProtocol().equalsIgnoreCase("http") && !url.getHost().equalsIgnoreCase("localhost")) {
                    return "https" + serverBaseUrl.substring(4);
                }
                return serverBaseUrl;
            }
            catch (MalformedURLException e) {
                log.warn("Could not customize swagger base server url: " + serverBaseUrl, (Throwable)e);
                return serverBaseUrl;
            }
        }
    }
}

