/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.swagger;

import ch.admin.bit.jeap.swagger.SwaggerProperties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.UserDetailsRepositoryReactiveAuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfiguration;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.userdetails.MapReactiveUserDetailsService;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@AutoConfiguration
@ConditionalOnClass(value={WebSecurityConfiguration.class})
@ConditionalOnExpression(value="'${jeap.swagger.status}' != 'CUSTOM'")
class SwaggerWebSecurityConfig {
    private static final String SWAGGER_ROLE = "swagger";

    SwaggerWebSecurityConfig() {
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class SwaggerWebfluxSecurity {
        private final SwaggerProperties swaggerProperties;

        @Bean
        @Order(value=-2147483640)
        public SecurityWebFilterChain swaggerSecurityWebFilterChain(ServerHttpSecurity http) {
            http.securityMatcher(this.swaggerRequestMatcher());
            switch (this.swaggerProperties.getStatus()) {
                case OPEN: {
                    http.authorizeExchange().anyExchange().permitAll();
                    break;
                }
                case SECURED: {
                    http.authorizeExchange().anyExchange().hasRole(SwaggerWebSecurityConfig.SWAGGER_ROLE);
                    http.httpBasic(this::setAuthenticationManager);
                    break;
                }
                case DISABLED: {
                    http.authorizeExchange().anyExchange().denyAll();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf((Object)this.swaggerProperties.getStatus()) + " is not a valid value");
                }
            }
            return http.build();
        }

        private ServerWebExchangeMatcher swaggerRequestMatcher() {
            return new OrServerWebExchangeMatcher(this.swaggerProperties.getAntPathPatters().stream().map(pattern -> new PathPatternParserServerWebExchangeMatcher(pattern, HttpMethod.GET)).collect(Collectors.toList()));
        }

        private void setAuthenticationManager(ServerHttpSecurity.HttpBasicSpec basicSpec) {
            if (this.swaggerProperties.getStatus() != SwaggerProperties.SwaggerStatus.SECURED) {
                return;
            }
            SwaggerProperties.Secured secured = this.swaggerProperties.getSecured();
            if (secured.getUsername() == null || secured.getPassword() == null) {
                throw new IllegalArgumentException("Swagger is set to secured but username or password is not set");
            }
            basicSpec.authenticationManager((ReactiveAuthenticationManager)new UserDetailsRepositoryReactiveAuthenticationManager((ReactiveUserDetailsService)new MapReactiveUserDetailsService(new UserDetails[]{User.withUsername((String)secured.getUsername()).password(secured.getPassword()).roles(new String[]{SwaggerWebSecurityConfig.SWAGGER_ROLE}).build()})));
        }

        @Generated
        public SwaggerWebfluxSecurity(SwaggerProperties swaggerProperties) {
            this.swaggerProperties = swaggerProperties;
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class SwaggerWebmvcSecurity {
        private final SwaggerProperties swaggerProperties;

        @Order(value=-2147483640)
        @Bean
        public SecurityFilterChain swaggerSecurityFilterChain(HttpSecurity http) throws Exception {
            http.securityMatcher(this.swaggerRequestMatcher());
            switch (this.swaggerProperties.getStatus()) {
                case OPEN: {
                    ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().anyRequest()).permitAll();
                    break;
                }
                case SECURED: {
                    ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().anyRequest()).hasRole(SwaggerWebSecurityConfig.SWAGGER_ROLE);
                    http.httpBasic();
                    http.authenticationManager(this.createSwaggerAuth((AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class)));
                    break;
                }
                case DISABLED: {
                    ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().anyRequest()).denyAll();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf((Object)this.swaggerProperties.getStatus()) + " is not a valid value");
                }
            }
            return (SecurityFilterChain)http.build();
        }

        private AuthenticationManager createSwaggerAuth(AuthenticationManagerBuilder auth) throws Exception {
            SwaggerProperties.Secured secured = this.swaggerProperties.getSecured();
            if (secured.getUsername() == null || secured.getPassword() == null) {
                throw new IllegalArgumentException("Swagger is set to secured but username or password is not set");
            }
            auth.inMemoryAuthentication().withUser(secured.getUsername()).password(secured.getPassword()).roles(new String[]{SwaggerWebSecurityConfig.SWAGGER_ROLE});
            return (AuthenticationManager)auth.build();
        }

        private RequestMatcher swaggerRequestMatcher() {
            return new OrRequestMatcher(this.swaggerProperties.getAntPathPatters().stream().map(pattern -> new AntPathRequestMatcher(pattern, "GET")).collect(Collectors.toList()));
        }

        @Generated
        public SwaggerWebmvcSecurity(SwaggerProperties swaggerProperties) {
            this.swaggerProperties = swaggerProperties;
        }
    }
}

