/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.tls;

import ch.admin.bit.jeap.tls.PemKeyCertPair;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

class PemKeyCertPairFactory {
    PemKeyCertPairFactory() {
    }

    static PemKeyCertPair createPemKeyCertPair(String host, Duration validity) {
        X500Principal subject;
        KeyPair keyPair = PemKeyCertPairFactory.generateKeyPair();
        X500Principal signedByPrincipal = subject = new X500Principal("CN=" + host);
        KeyPair signedByKeyPair = keyPair;
        long notBefore = System.currentTimeMillis();
        long notAfter = notBefore + validity.toMillis();
        ASN1Encodable[] encodableAltNames = new ASN1Encodable[]{new GeneralName(2, host)};
        KeyPurposeId[] purposes = new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth};
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(signedByPrincipal, BigInteger.ONE, new Date(notBefore), new Date(notAfter), subject, keyPair.getPublic());
        certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(160));
        certBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(purposes));
        certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new DERSequence(encodableAltNames));
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(signedByKeyPair.getPrivate());
        X509CertificateHolder certHolder = certBuilder.build(signer);
        String privateKeyPem = PemKeyCertPairFactory.getPrivateKeyPem(keyPair);
        String certPem = PemKeyCertPairFactory.getCertificatePem(certHolder);
        return new PemKeyCertPair(privateKeyPem, certPem);
    }

    private static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048, new SecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("Unable to create RSA key pair. Maybe there is a problem with the cryptography provider?", gse);
        }
    }

    private static String getPrivateKeyPem(KeyPair keyPair) {
        return PemKeyCertPairFactory.createPem(keyPair.getPrivate());
    }

    private static String getCertificatePem(X509CertificateHolder certHolder) {
        return PemKeyCertPairFactory.createPem(certHolder);
    }

    private static String createPem(Object pemmable) {
        try {
            StringWriter writer = new StringWriter();
            JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
            pemWriter.writeObject(pemmable);
            pemWriter.close();
            return writer.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to encode the given object in PEM format.", e);
        }
    }
}

