/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.tls;

import ch.admin.bit.jeap.tls.PemKeyCertPair;
import ch.admin.bit.jeap.tls.PemKeyCertPairFactory;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class EnableTlsEnvPostprocessor
implements EnvironmentPostProcessor {
    static final String TLS_ENABLED_PROPERTY_NAME = "jeap.web.tls.enabled";
    static final String TLS_HOSTNAME_PROPERTY_NAME = "jeap.web.tls.self-signed-cert.hostname";
    static final String TLS_DAYS_VALID_PROPERTY_NAME = "jeap.web.tls.self-signed-cert.days-valid";
    static final int TLS_DAYS_VALID_DEFAULT = 3650;
    static final String TLS_PROPERTY_SOURCE_NAME = "jeap-tls-config";
    static final String SSL_BUNDLE_NAME = "web-server";
    static final String SSL_BUNDLE_KEY_PROPERTY_NAME = "spring.ssl.bundle.pem.web-server.keystore.private-key";
    static final String SSL_BUNDLE_CERT_PROPERTY_NAME = "spring.ssl.bundle.pem.web-server.keystore.certificate";
    static final String SSL_BUNDLE_PROPERTY_NAME = "server.ssl.bundle";
    static final String HTTP_2_ENABLED_PROPERTY_NAME = "server.http2.enabled";
    static final String SPRING_APPLICATION_NAME_PROPERTY_NAME = "spring.application.name";
    private final Log log;
    private PemKeyCertPair pemKeyCertPair;

    public EnableTlsEnvPostprocessor(DeferredLogFactory logFactory) {
        this.log = logFactory.getLog(this.getClass());
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (this.isTlsEnabled((Environment)environment)) {
            this.log.info((Object)"jEAP TLS is enabled");
            this.initializePemKeyCertPair((Environment)environment);
            HashMap<String, Object> tlsConfigProperties = new HashMap<String, Object>();
            tlsConfigProperties.put(SSL_BUNDLE_KEY_PROPERTY_NAME, this.pemKeyCertPair.key());
            tlsConfigProperties.put(SSL_BUNDLE_CERT_PROPERTY_NAME, this.pemKeyCertPair.cert());
            tlsConfigProperties.put(SSL_BUNDLE_PROPERTY_NAME, SSL_BUNDLE_NAME);
            tlsConfigProperties.put(HTTP_2_ENABLED_PROPERTY_NAME, "true");
            this.addPropertiesAsPropertySource(environment, tlsConfigProperties, TLS_PROPERTY_SOURCE_NAME);
        } else {
            this.log.info((Object)"jEAP TLS is disabled");
        }
    }

    private boolean isTlsEnabled(Environment environment) {
        return environment.getProperty(TLS_ENABLED_PROPERTY_NAME, "true").equalsIgnoreCase("true");
    }

    private void initializePemKeyCertPair(Environment environment) {
        if (this.pemKeyCertPair == null) {
            String hostName = this.getHostname(environment);
            Duration validity = this.getValidity(environment);
            this.log.info((Object)"Creating a self-signed certificate for hostname '%s' valid '%s' days.".formatted(hostName, validity.toDays()));
            this.pemKeyCertPair = PemKeyCertPairFactory.createPemKeyCertPair(hostName, validity);
        }
    }

    private String getHostname(Environment environment) {
        String configuredHostname = environment.getProperty(TLS_HOSTNAME_PROPERTY_NAME);
        if (StringUtils.hasText((String)configuredHostname)) {
            return configuredHostname;
        }
        return this.getSpringApplicationName(environment);
    }

    private String getSpringApplicationName(Environment environment) {
        return environment.getProperty(SPRING_APPLICATION_NAME_PROPERTY_NAME, "unknown");
    }

    private Duration getValidity(Environment environment) {
        String daysValidStr = environment.getProperty(TLS_DAYS_VALID_PROPERTY_NAME);
        if (StringUtils.hasText((String)daysValidStr)) {
            try {
                return Duration.ofDays(Integer.parseInt(daysValidStr));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot parse property %s as an int from given value '%s'.".formatted(TLS_DAYS_VALID_PROPERTY_NAME, daysValidStr), e);
            }
        }
        return Duration.ofDays(3650L);
    }

    private void addPropertiesAsPropertySource(ConfigurableEnvironment environment, Map<String, Object> properties, String propertySourceName) {
        if (StringUtils.hasText((String)environment.getProperty(SSL_BUNDLE_PROPERTY_NAME))) {
            this.log.debug((Object)"Server SSL bundle already configured.");
        } else {
            this.log.info((Object)"Adding config properties (%s) to environment in config source %s.".formatted(String.join((CharSequence)", ", properties.keySet()), propertySourceName));
            environment.getPropertySources().addLast((PropertySource)new MapPropertySource(propertySourceName, properties));
        }
    }
}

