/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.db.tx.config;

import ch.admin.bit.jeap.db.tx.ReadReplicaAwareTransactionManager;
import io.micrometer.core.instrument.MeterRegistry;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.transaction.PlatformTransactionManager;

public class ReadReplicaAwareTransactionManagerBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadReplicaAwareTransactionManagerBeanPostProcessor.class);
    private static final String TRANSACTION_MANAGER = "transactionManager";
    private BeanFactory beanFactory;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (TRANSACTION_MANAGER.equals(beanName) && PlatformTransactionManager.class.isAssignableFrom(bean.getClass())) {
            log.info("Replacing the transactionManager with a ReadReplicaAwareTransactionManager");
            boolean routeTransactionsToReadReplica = false;
            PlatformTransactionManager delegate = (PlatformTransactionManager)bean;
            return new ReadReplicaAwareTransactionManager(delegate, routeTransactionsToReadReplica, () -> (MeterRegistry)this.beanFactory.getBean(MeterRegistry.class));
        }
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Generated
    public ReadReplicaAwareTransactionManagerBeanPostProcessor() {
    }
}

