/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.db.tx;

import ch.admin.bit.jeap.db.tx.TransactionalReadReplica;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class ReadReplicaAwareTransactionManager
implements PlatformTransactionManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadReplicaAwareTransactionManager.class);
    private static final String JEAP_AWS_DB_TRANSACTION_READREPLICA = "jeap_db_transaction_readreplica";
    private static final String JEAP_AWS_DB_TRANSACTION_RW = "jeap_db_transaction_rw";
    static final ThreadLocal<Boolean> TOP_LEVEL_TRANSACTION_READ_ONLY = new ThreadLocal();
    static final ThreadLocal<Boolean> TOP_LEVEL_TRANSACTION_ROUTED_TO_READ_REPLICA = new ThreadLocal();
    static final ThreadLocal<AtomicInteger> NESTING_LEVEL = ThreadLocal.withInitial(() -> new AtomicInteger(0));
    private final PlatformTransactionManager delegate;
    private final boolean routeTransactionsToReadReplica;
    private final Supplier<MeterRegistry> meterRegistrySupplier;
    private Counter readReplicaCounter;
    private Counter readWriteCounter;

    public ReadReplicaAwareTransactionManager(PlatformTransactionManager delegate, boolean routeTransactionsToReadReplica, Supplier<MeterRegistry> meterRegistrySupplier) {
        this.delegate = delegate;
        this.routeTransactionsToReadReplica = routeTransactionsToReadReplica;
        this.meterRegistrySupplier = meterRegistrySupplier;
    }

    private void initCounters() {
        if (this.readReplicaCounter == null) {
            this.readReplicaCounter = Counter.builder((String)JEAP_AWS_DB_TRANSACTION_READREPLICA).description("Transactions routed to read replicas").register(this.meterRegistrySupplier.get());
            this.readWriteCounter = Counter.builder((String)JEAP_AWS_DB_TRANSACTION_RW).description("Writer instance transactions").register(this.meterRegistrySupplier.get());
        }
    }

    public TransactionStatus getTransaction(TransactionDefinition definition) throws TransactionException {
        if (log.isDebugEnabled()) {
            log.debug("Transaction definition is " + (definition.isReadOnly() ? "read-only" : "read-write"));
        }
        if (ReadReplicaAwareTransactionManager.isTopLevelTransaction()) {
            if (this.routeTransactionsToReadReplica && !definition.isReadOnly()) {
                throw new IllegalStateException("Read-write transactions cannot be annotated with " + TransactionalReadReplica.class.getSimpleName() + " or handled by the " + this.getClass().getSimpleName() + " when routing to read replicas.");
            }
            ReadReplicaAwareTransactionManager.setTopLevelTransactionReadOnly(definition.isReadOnly());
            ReadReplicaAwareTransactionManager.setTopLevelTransactionRoutedToReadReplica(this.routeTransactionsToReadReplica);
            this.updateMetric(this.routeTransactionsToReadReplica);
        } else if (!definition.isReadOnly() && ReadReplicaAwareTransactionManager.isTopLevelTransactionReadOnly().booleanValue()) {
            throw new IllegalStateException("Read-write transactions cannot be nested in top level read-only transactions. This will lead to missing write flushes and read replicas refusing to execute writes.");
        }
        NESTING_LEVEL.get().incrementAndGet();
        try {
            return this.delegate.getTransaction(definition);
        }
        catch (Exception e) {
            NESTING_LEVEL.get().decrementAndGet();
            if (ReadReplicaAwareTransactionManager.isTopLevelTransaction()) {
                ReadReplicaAwareTransactionManager.clearTransactionThreadLocals();
            }
            throw e;
        }
    }

    private void updateMetric(boolean readReplica) {
        this.initCounters();
        if (readReplica) {
            this.readReplicaCounter.increment();
        } else {
            this.readWriteCounter.increment();
        }
    }

    public void commit(TransactionStatus status) throws TransactionException {
        if (log.isDebugEnabled()) {
            log.debug("Committing transaction.");
        }
        try {
            this.delegate.commit(status);
        }
        finally {
            NESTING_LEVEL.get().decrementAndGet();
            if (ReadReplicaAwareTransactionManager.isTopLevelTransaction()) {
                ReadReplicaAwareTransactionManager.clearTransactionThreadLocals();
            }
        }
    }

    public void rollback(TransactionStatus status) throws TransactionException {
        if (log.isDebugEnabled()) {
            log.debug("Rolling back transaction.");
        }
        try {
            this.delegate.rollback(status);
        }
        finally {
            NESTING_LEVEL.get().decrementAndGet();
            if (ReadReplicaAwareTransactionManager.isTopLevelTransaction()) {
                ReadReplicaAwareTransactionManager.clearTransactionThreadLocals();
            }
        }
    }

    private static boolean isTopLevelTransaction() {
        return NESTING_LEVEL.get().get() == 0;
    }

    private static void setTopLevelTransactionRoutedToReadReplica(boolean routeTransactionsToReadReplica) {
        TOP_LEVEL_TRANSACTION_ROUTED_TO_READ_REPLICA.set(routeTransactionsToReadReplica);
    }

    private static void setTopLevelTransactionReadOnly(boolean isReadOnly) {
        TOP_LEVEL_TRANSACTION_READ_ONLY.set(isReadOnly);
    }

    public static boolean routeTopLevelTransactionToReadReplica() {
        Boolean value = TOP_LEVEL_TRANSACTION_ROUTED_TO_READ_REPLICA.get();
        return value != null && value != false;
    }

    private static Boolean isTopLevelTransactionReadOnly() {
        return TOP_LEVEL_TRANSACTION_READ_ONLY.get();
    }

    private static void clearTransactionThreadLocals() {
        TOP_LEVEL_TRANSACTION_READ_ONLY.remove();
        TOP_LEVEL_TRANSACTION_ROUTED_TO_READ_REPLICA.remove();
    }

    @Generated
    public boolean isRouteTransactionsToReadReplica() {
        return this.routeTransactionsToReadReplica;
    }
}

