/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.db.tx.config;

import ch.admin.bit.jeap.db.tx.ReadReplicaAwareTransactionManager;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.transaction.PlatformTransactionManager;

public class ReadReplicaTransactionManagerBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryAware,
EnvironmentAware {
    private static final String READ_REPLICA_TRANSACTION_MANAGER = "readReplicaTransactionManager";
    private static final String TRANSACTION_MANAGER = "transactionManager";
    private BeanFactory beanFactory;
    private Environment environment;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        boolean readReplicaActive = (Boolean)this.environment.getProperty("jeap.datasource.replica.enabled", Boolean.class, (Object)false);
        if (readReplicaActive) {
            registry.getBeanDefinition(TRANSACTION_MANAGER).setPrimary(true);
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(ReadReplicaAwareTransactionManager.class);
            beanDefinition.setPrimary(false);
            beanDefinition.setDependsOn(new String[]{TRANSACTION_MANAGER});
            beanDefinition.setAutowireMode(0);
            beanDefinition.setInstanceSupplier(this::getTransactionManager);
            registry.registerBeanDefinition(READ_REPLICA_TRANSACTION_MANAGER, (BeanDefinition)beanDefinition);
        } else {
            registry.registerAlias(TRANSACTION_MANAGER, READ_REPLICA_TRANSACTION_MANAGER);
        }
    }

    private ReadReplicaAwareTransactionManager getTransactionManager() {
        PlatformTransactionManager delegate = (PlatformTransactionManager)this.beanFactory.getBean(TRANSACTION_MANAGER);
        return new ReadReplicaAwareTransactionManager(delegate, true, () -> (MeterRegistry)this.beanFactory.getBean(MeterRegistry.class));
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

