/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.vault;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.ResourcePropertySource;

abstract class AbstractVaultPropertiesEnvPostProcessor
implements EnvironmentPostProcessor {
    protected Log log;

    protected AbstractVaultPropertiesEnvPostProcessor(DeferredLogFactory logFactory) {
        this.log = logFactory.getLog(this.getClass());
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        boolean vaultEnabled = Boolean.parseBoolean(environment.getProperty("spring.cloud.vault.enabled", "true"));
        if (vaultEnabled) {
            this.doPostProcessEnvironment(environment);
        } else {
            this.log.info((Object)"Vault is disabled -> won't add any vault properties");
        }
    }

    protected abstract void doPostProcessEnvironment(ConfigurableEnvironment var1);

    protected void addPropertySourceFromResource(ConfigurableEnvironment env, String resourcePath) {
        ResourcePropertySource properties = new ResourcePropertySource(resourcePath);
        Map<String, Object> propertiesNotYetSetInEnvironment = Arrays.stream(properties.getPropertyNames()).filter(propertyName -> !env.containsProperty(propertyName)).collect(Collectors.toMap(propertyName -> propertyName, arg_0 -> ((ResourcePropertySource)properties).getProperty(arg_0)));
        if (!propertiesNotYetSetInEnvironment.isEmpty()) {
            this.log.info((Object)"Adding missing vault properties (%s) in config source %s.".formatted(String.join((CharSequence)", ", propertiesNotYetSetInEnvironment.keySet()), properties.getName()));
            env.getPropertySources().addLast((PropertySource)new MapPropertySource(properties.getName(), propertiesNotYetSetInEnvironment));
        } else {
            this.log.info((Object)"Not adding any vault properties.");
        }
    }
}

