/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.vault;

import ch.admin.bit.jeap.vault.AbstractVaultPropertiesEnvPostProcessor;
import java.util.Objects;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class VaultBasePropertiesEnvPostProcessor
extends AbstractVaultPropertiesEnvPostProcessor
implements Ordered {
    private static final String LOCATION_BASE_PROPERTIES = "classpath:/jeap-vault-starter-base.properties";
    private static final String LOCATION_RHOS_BASE_PROPERTIES = "classpath:/jeap-vault-starter-rhos-base.properties";

    protected VaultBasePropertiesEnvPostProcessor(DeferredLogFactory logFactory) {
        super(logFactory);
    }

    @Override
    protected void doPostProcessEnvironment(ConfigurableEnvironment environment) {
        boolean isInitContainer = Boolean.parseBoolean(Objects.toString(environment.getSystemEnvironment().get("IS_INIT_CONTAINER_EXECUTION")));
        if (isInitContainer) {
            this.log.info((Object)"Application is running as database migration job container.");
        } else if (CloudPlatform.KUBERNETES.isActive((Environment)environment)) {
            this.log.info((Object)"Vault for RHOS is enabled -> adding missing vault base properties.");
            this.addPropertySourceFromResource(environment, LOCATION_RHOS_BASE_PROPERTIES);
        } else {
            this.log.info((Object)"Vault is enabled -> adding missing vault base properties.");
            this.addPropertySourceFromResource(environment, LOCATION_BASE_PROPERTIES);
        }
    }

    public int getOrder() {
        return -2147483639;
    }
}

