/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.vault;

import java.util.Map;
import java.util.Set;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;
import org.springframework.vault.client.ClientHttpRequestFactoryFactory;

public class SuppressInvalidCookieHeaderWarningEnvPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (this.isVaultProfileActive(environment.getActiveProfiles()) && this.apacheHttpClientActiveForVault()) {
            Map<String, String> map = Map.of("logging.level.org.apache.http.client.protocol", "ERROR");
            environment.getPropertySources().addLast((PropertySource)new MapPropertySource(this.getClass().getSimpleName(), map));
        }
    }

    private boolean apacheHttpClientActiveForVault() {
        return ClassUtils.isPresent((String)"org.apache.http.client.HttpClient", (ClassLoader)ClientHttpRequestFactoryFactory.class.getClassLoader());
    }

    private boolean isVaultProfileActive(String[] activeProfiles) {
        return activeProfiles != null && (Set.of(activeProfiles).contains("vault") || Set.of(activeProfiles).contains("jeap-vault"));
    }
}

