/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.vault.config;

import ch.admin.bit.jeap.vault.config.conditions.OnVaultAndAppRoleCondition;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={OnVaultAndAppRoleCondition.class})
public class JeapVaultAppRoleConfigLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapVaultAppRoleConfigLogger.class);
    @Value(value="${spring.cloud.vault.uri}")
    private String vaultUrl;
    @Value(value="${spring.cloud.vault.app-role.app-role-path}")
    private String appRolePath;
    @Value(value="${spring.cloud.vault.kv.backend}")
    private String secretPath;
    private static boolean bootstrapped = false;

    @PostConstruct
    void logVaultConfig() {
        if (!bootstrapped) {
            log.info("Vault integration is enabled with authentication method APPROLE, using vault at '{}' with app role path '{}' and secret path '{}'", new Object[]{this.vaultUrl, this.appRolePath, this.secretPath});
        }
        bootstrapped = true;
    }
}

