/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.vault;

import ch.admin.bit.jeap.vault.AbstractVaultPropertiesEnvPostProcessor;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class VaultDefaultPropertiesEnvPostProcessor
extends AbstractVaultPropertiesEnvPostProcessor
implements Ordered {
    private static final String LOCATION_DEFAULT_PROPERTIES = "classpath:/jeap-vault-starter-default.properties";

    protected VaultDefaultPropertiesEnvPostProcessor(DeferredLogFactory logFactory) {
        super(logFactory);
    }

    @Override
    protected void doPostProcessEnvironment(ConfigurableEnvironment environment) {
        if (!CloudPlatform.KUBERNETES.isActive((Environment)environment)) {
            this.log.info((Object)"Vault is enabled -> adding missing vault default properties.");
            this.addPropertySourceFromResource(environment, LOCATION_DEFAULT_PROPERTIES);
        } else {
            this.log.info((Object)"Vault for RHOS is enabled --> not adding any vault default properties.");
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

