/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.vault.config;

import ch.admin.bit.jeap.vault.config.conditions.OnVaultAndKubernetesCondition;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Conditional;

@AutoConfiguration
@Conditional(value={OnVaultAndKubernetesCondition.class})
public class JeapVaultKubernetesConfigLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapVaultKubernetesConfigLogger.class);
    @Value(value="${spring.cloud.vault.uri}")
    private String vaultUrl;
    @Value(value="${jeap.vault.kubernetes.role}")
    private String kubernetesRole;
    @Value(value="${jeap.vault.kubernetes.kubernetes-path}")
    private String kubernetesPath;
    @Value(value="${jeap.vault.kv.backend}")
    private String keyVaultBackend;
    private static boolean bootstrapped = false;

    @PostConstruct
    void logVaultConfig() {
        if (!bootstrapped) {
            log.info("Vault integration is enabled with authentication method KUBERNETES, using vault at '{}' with kubernetes role '{}', kubernetes path '{}', and kv.backend '{}'", new Object[]{this.vaultUrl, this.kubernetesRole, this.kubernetesPath, this.keyVaultBackend});
        }
        bootstrapped = true;
    }
}

