/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.truststoreplugin.filecertrepo;

import ch.admin.bit.jeap.truststoreplugin.filecertrepo.FileCertRepoException;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;

public class FileCertRepo {
    private final Path repoPath;
    private final List<String> includes;
    private final List<String> extensions;

    public static FileCertRepo of(Path repoPath, List<String> includes, List<String> extensions) {
        return new FileCertRepo(repoPath, includes, extensions);
    }

    public Stream<File> streamCertFiles(String environment) {
        try {
            SuffixFileFilter extensionsFilter = new SuffixFileFilter(this.extensions, IOCase.INSENSITIVE);
            return this.createCertificateSourcePaths(environment).map(Path::toFile).filter(File::exists).filter(File::isDirectory).flatMap(arg_0 -> this.lambda$streamCertFiles$0((IOFileFilter)extensionsFilter, arg_0));
        }
        catch (Exception e) {
            throw FileCertRepoException.fileAccessFailed(e);
        }
    }

    private Stream<File> getCertFiles(File directory, IOFileFilter filter) {
        return FileUtils.listFiles((File)directory, (IOFileFilter)filter, null).stream();
    }

    private Stream<Path> createCertificateSourcePaths(String environment) {
        return this.includes.stream().map(this.repoPath::resolve).flatMap(includePath -> this.createIncludeSourcePaths((Path)includePath, environment));
    }

    private Stream<Path> createIncludeSourcePaths(Path includePath, String environment) {
        return Stream.of(includePath, includePath.resolve(environment));
    }

    @Generated
    private FileCertRepo(Path repoPath, List<String> includes, List<String> extensions) {
        this.repoPath = repoPath;
        this.includes = includes;
        this.extensions = extensions;
    }

    @Generated
    public Path getRepoPath() {
        return this.repoPath;
    }

    private /* synthetic */ Stream lambda$streamCertFiles$0(IOFileFilter extensionsFilter, File certsSourceDir) {
        return this.getCertFiles(certsSourceDir, extensionsFilter);
    }
}

