/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.truststoreplugin.gitcertrepo;

import ch.admin.bit.jeap.truststoreplugin.gitcertrepo.GitCertRepoException;
import java.io.File;
import java.net.URI;
import lombok.Generated;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitCertRepo {
    private final Log log;
    private final URI uri;
    private final String branch;
    private final String tokenEnvironmentPropertyName;

    public static GitCertRepo of(URI uri, String branch, String tokenEnvironmentPropertyName) {
        return new GitCertRepo((Log)new SystemStreamLog(), uri, branch, tokenEnvironmentPropertyName);
    }

    public void cloneTo(File targetDirectory) {
        try {
            String token = System.getenv(this.tokenEnvironmentPropertyName);
            if (token != null && !token.isEmpty()) {
                this.log.info((CharSequence)("Found a " + this.tokenEnvironmentPropertyName + " in environment: using jgit with this token to clone the repository"));
                ((CloneCommand)Git.cloneRepository().setURI(this.uri.toString()).setBranch(this.branch).setDirectory(targetDirectory).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider("no-username-when-using-token", token))).call();
            } else {
                this.log.info((CharSequence)("No " + this.tokenEnvironmentPropertyName + " found in environment: using git client with system credentials to clone the repository"));
                ProcessBuilder pb = new ProcessBuilder("git", "clone", "--branch", this.branch, "--single-branch", this.uri.toString(), targetDirectory.getAbsolutePath());
                pb.directory(targetDirectory);
                Process process = pb.start();
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    this.log.error((CharSequence)("Failed to clone repository. Exit code: " + exitCode));
                    throw new IllegalStateException("Failed to clone repository. Exit code: " + exitCode);
                }
            }
            this.log.info((CharSequence)("Cloned branch '" + this.branch + "' successfully."));
        }
        catch (Exception e) {
            throw GitCertRepoException.cloningFailed(this.uri, this.branch, e);
        }
    }

    @Generated
    private GitCertRepo(Log log, URI uri, String branch, String tokenEnvironmentPropertyName) {
        this.log = log;
        this.uri = uri;
        this.branch = branch;
        this.tokenEnvironmentPropertyName = tokenEnvironmentPropertyName;
    }
}

