/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.truststoreplugin.mojo;

import ch.admin.bit.jeap.truststoreplugin.filecertrepo.FileCertRepo;
import ch.admin.bit.jeap.truststoreplugin.gitcertrepo.GitCertRepo;
import ch.admin.bit.jeap.truststoreplugin.truststore.TrustStore;
import ch.admin.bit.jeap.truststoreplugin.truststore.TruststoreType;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="build-truststores", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class BuildTruststoresMojo
extends AbstractMojo {
    @Parameter
    private URL certificateRepositoryUrl;
    @Parameter(defaultValue="master")
    private String certificateRepositoryBranch;
    @Parameter
    private File certificateRepositoryDir;
    @Parameter
    private List<File> outputDirs;
    @Parameter(defaultValue="JKS")
    private TruststoreType trustStoreType;
    @Parameter(defaultValue="truststore")
    private String trustStoreName;
    @Parameter(defaultValue="changeit")
    private String trustStorePassword;
    @Parameter
    private List<String> environments;
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> extensions;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException {
        if (this.session.isOffline() && this.certificateRepositoryDir == null) {
            this.getLog().warn((CharSequence)"Offline mode - not downloading certificates from repository. Alternatively configure 'certificateRepositoryDir'");
            return;
        }
        this.checkParameters();
        this.setDefaultsIfNotConfigured();
        File fileCertRepoDirectory = this.getFileCertRepoDirectory();
        FileCertRepo fileCertRepo = FileCertRepo.of(fileCertRepoDirectory.toPath(), this.includes, this.extensions);
        for (String environment : this.environments) {
            try {
                TrustStore trustStore = this.createTrustStore(fileCertRepo, environment);
                this.distributeTruststore(trustStore, environment);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Creating truststore for environment '" + environment + "' failed."), (Throwable)e);
                throw new MojoExecutionException("Truststore building failed.", e);
            }
        }
    }

    private File getFileCertRepoDirectory() throws MojoExecutionException {
        if (this.certificateRepositoryDir != null) {
            return this.certificateRepositoryDir;
        }
        return this.cloneGitRepoToTempDir(this.certificateRepositoryUrl, this.certificateRepositoryBranch);
    }

    private File cloneGitRepoToTempDir(URL gitRepoUrl, String branch) throws MojoExecutionException {
        try {
            File tempRepoBranchDir = Files.createTempDirectory(branch, new FileAttribute[0]).toFile();
            FileUtils.forceDeleteOnExit((File)tempRepoBranchDir);
            GitCertRepo gitCertRepo = GitCertRepo.of(gitRepoUrl.toURI(), branch);
            this.getLog().info((CharSequence)("Cloning git repo " + String.valueOf(gitRepoUrl) + " at branch " + branch + " to directory " + tempRepoBranchDir.getAbsolutePath()));
            gitCertRepo.cloneTo(tempRepoBranchDir);
            return tempRepoBranchDir;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to clone git repository " + String.valueOf(gitRepoUrl) + " at branch " + branch + " to a temp dir.", e);
        }
    }

    private TrustStore createTrustStore(FileCertRepo fileCertRepo, String environment) {
        this.getLog().info((CharSequence)("Creating truststore for environment '" + environment + "' from certificate file repository " + String.valueOf(fileCertRepo.getRepoPath().toAbsolutePath())));
        TrustStore trustStore = TrustStore.of(this.trustStoreType, this.trustStorePassword);
        fileCertRepo.streamCertFiles(environment).forEach(trustStore::addCertificate);
        return trustStore;
    }

    private void distributeTruststore(TrustStore trustStore, String environment) {
        this.outputDirs.forEach(outputDir -> {
            outputDir.mkdirs();
            String filename = this.trustStoreName + "-" + environment + "." + this.trustStoreType.getFileExtension();
            File trustStoreFile = new File((File)outputDir, filename);
            trustStore.store(trustStoreFile);
            this.getLog().info((CharSequence)("Created truststore " + trustStoreFile.getAbsolutePath()));
        });
    }

    private void setDefaultsIfNotConfigured() {
        if (this.environments == null || this.environments.isEmpty()) {
            this.environments = List.of("dev", "ref", "abn", "prod");
        }
        if (this.includes == null || this.includes.isEmpty()) {
            this.includes = List.of("general");
        }
        if (this.extensions == null || this.extensions.isEmpty()) {
            this.extensions = List.of("cert", "cer", "crt", "pem");
        }
        if (this.outputDirs == null || this.outputDirs.isEmpty()) {
            this.outputDirs = List.of(new File(this.project.getBasedir(), "target/classes"));
        }
    }

    private void checkParameters() throws MojoExecutionException {
        if (this.certificateRepositoryUrl == null && this.certificateRepositoryDir == null) {
            throw new MojoExecutionException("One of the parameters 'certificateRepositoryUrl' and 'certificateRepositoryDir' must be configured.");
        }
        if (this.certificateRepositoryUrl != null && this.certificateRepositoryDir != null) {
            throw new MojoExecutionException("Parameters 'certificateRepositoryUrl' and 'certificateRepositoryDir' must not both be configured.");
        }
    }

    @Generated
    public URL getCertificateRepositoryUrl() {
        return this.certificateRepositoryUrl;
    }

    @Generated
    public String getCertificateRepositoryBranch() {
        return this.certificateRepositoryBranch;
    }

    @Generated
    public File getCertificateRepositoryDir() {
        return this.certificateRepositoryDir;
    }

    @Generated
    public List<File> getOutputDirs() {
        return this.outputDirs;
    }

    @Generated
    public TruststoreType getTrustStoreType() {
        return this.trustStoreType;
    }

    @Generated
    public String getTrustStoreName() {
        return this.trustStoreName;
    }

    @Generated
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Generated
    public List<String> getEnvironments() {
        return this.environments;
    }

    @Generated
    public List<String> getIncludes() {
        return this.includes;
    }

    @Generated
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Generated
    public MavenProject getProject() {
        return this.project;
    }

    @Generated
    public MavenSession getSession() {
        return this.session;
    }
}

