/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.truststoreplugin.truststore;

import ch.admin.bit.jeap.truststoreplugin.truststore.TrustStoreException;
import ch.admin.bit.jeap.truststoreplugin.truststore.TruststoreType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class TrustStore {
    private final KeyStore keyStore;
    private final char[] password;

    public static TrustStore of(TruststoreType type, String password) {
        return new TrustStore(type, password);
    }

    private TrustStore(TruststoreType type, String password) {
        this.password = password.toCharArray();
        this.keyStore = this.createTruststore(type);
    }

    public void addCertificate(File certFile) {
        X509Certificate certificate = this.loadX509Certificate(certFile);
        try {
            String alias = this.createAlias(certificate);
            this.keyStore.setCertificateEntry(alias, certificate);
        }
        catch (KeyStoreException e) {
            throw TrustStoreException.addingCertificateFailed(certificate, e);
        }
    }

    public void store(File targetFile) {
        try (FileOutputStream trustStoreOutputStream = new FileOutputStream(targetFile);){
            this.keyStore.store(trustStoreOutputStream, this.password);
        }
        catch (Exception e) {
            throw TrustStoreException.storingFailed(targetFile, e);
        }
    }

    private String createAlias(X509Certificate certificate) {
        X500Principal subject = certificate.getSubjectX500Principal();
        X500Principal issuer = certificate.getIssuerX500Principal();
        return String.valueOf(subject) + " by " + issuer.getName() + " (" + String.valueOf(certificate.getSerialNumber()) + ")";
    }

    private KeyStore createTruststore(TruststoreType type) {
        try {
            KeyStore keyStore = KeyStore.getInstance(type.name());
            keyStore.load(null, this.password);
            return keyStore;
        }
        catch (Exception e) {
            throw TrustStoreException.trustStoreCreationFailed(e);
        }
    }

    private X509Certificate loadX509Certificate(File certFile) {
        X509Certificate x509Certificate;
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        FileInputStream certData = new FileInputStream(certFile);
        try {
            x509Certificate = (X509Certificate)certFactory.generateCertificate(certData);
        }
        catch (Throwable throwable) {
            try {
                try {
                    certData.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw TrustStoreException.certificateLoadFailed(certFile, e);
            }
        }
        certData.close();
        return x509Certificate;
    }
}

