/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.jotlmsg.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hsmf.datatypes.ChunkBasedPropertyValue;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.util.LittleEndian;

public class PropertiesChunk {
    public static final String PREFIX = "__substg1.0_";
    public static final int FLAG_READABLE = 2;
    public static final int FLAG_WRITEABLE = 4;
    private Map<MAPIProperty, PropertyValue> properties = new HashMap<MAPIProperty, PropertyValue>();

    public void setProperty(PropertyValue value) {
        this.properties.put(value.getProperty(), value);
    }

    public PropertyValue getProperty(MAPIProperty property) {
        return this.properties.get(property);
    }

    public void writeTo(DirectoryEntry directory) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        List<PropertyValue> values = this.writeHeaderData(baos);
        baos.close();
        directory.createDocument("__properties_version1.0", (InputStream)new ByteArrayInputStream(baos.toByteArray()));
        this.writeNodeData(directory, values);
    }

    protected void writeNodeData(DirectoryEntry directory, List<PropertyValue> values) throws IOException {
        for (PropertyValue value : values) {
            byte[] bytes = (byte[])value.getValue();
            String nodeName = PREFIX + this.getFileName(value.getProperty());
            directory.createDocument(nodeName, (InputStream)new ByteArrayInputStream(bytes));
        }
    }

    protected List<PropertyValue> writeHeaderData(OutputStream out) throws IOException {
        ArrayList<PropertyValue> variableLengthProperties = new ArrayList<PropertyValue>();
        for (Map.Entry<MAPIProperty, PropertyValue> entry : this.properties.entrySet()) {
            MAPIProperty property = entry.getKey();
            PropertyValue value = entry.getValue();
            if (value == null) continue;
            if (value instanceof ChunkBasedPropertyValue) {
                throw new IOException("ChunkBasedPropertyValue not supported yet");
            }
            int tag = Integer.parseInt(this.getFileName(property), 16);
            LittleEndian.putUInt((long)tag, (OutputStream)out);
            LittleEndian.putUInt((long)value.getFlags(), (OutputStream)out);
            Types.MAPIType type = this.getTypeMapping(property.usualType);
            if (type.isFixedLength()) {
                this.writeFixedLengthValueHeader(out, property, type, value);
                continue;
            }
            this.writeVariableLengthValueHeader(out, property, type, value);
            variableLengthProperties.add(value);
        }
        return variableLengthProperties;
    }

    private void writeFixedLengthValueHeader(OutputStream out, MAPIProperty property, Types.MAPIType type, PropertyValue value) throws IOException {
        int length;
        byte[] bytes = (byte[])value.getValue();
        int n = length = bytes != null ? bytes.length : 0;
        if (bytes != null) {
            byte[] reversed = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                reversed[bytes.length - i - 1] = bytes[i];
            }
            out.write(reversed);
        }
        out.write(new byte[8 - length]);
    }

    private void writeVariableLengthValueHeader(OutputStream out, MAPIProperty property, Types.MAPIType type, PropertyValue value) throws IOException {
        int length;
        byte[] bytes = (byte[])value.getValue();
        int n = length = bytes != null ? bytes.length : 0;
        if (type == Types.UNICODE_STRING) {
            length += 2;
        } else if (type == Types.ASCII_STRING) {
            ++length;
        }
        LittleEndian.putUInt((long)length, (OutputStream)out);
        LittleEndian.putUInt((long)0L, (OutputStream)out);
    }

    private String getFileName(MAPIProperty property) {
        String str = Integer.toHexString(property.id).toUpperCase(Locale.ROOT);
        while (str.length() < 4) {
            str = "0" + str;
        }
        Types.MAPIType type = this.getTypeMapping(property.usualType);
        return str + type.asFileEnding();
    }

    private Types.MAPIType getTypeMapping(Types.MAPIType type) {
        return type == Types.ASCII_STRING ? Types.UNICODE_STRING : type;
    }
}

