/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.jotlmsg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.util.IOUtils;

public class OutlookMessageAttachment {
    private final String name;
    private String mimeType;
    private InputStreamCreator inputStreamCreator;

    public OutlookMessageAttachment(String name, String mimeType, InputStreamCreator creator) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("name is not defined");
        }
        this.name = name;
        this.mimeType = mimeType;
        this.inputStreamCreator = creator;
    }

    public OutlookMessageAttachment(String name, String mimeType, InputStream input) {
        this(name, mimeType, input != null ? new MemoryInputStreamCreator(input) : null);
    }

    public final String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public InputStreamCreator getInputStreamCreator() {
        return this.inputStreamCreator;
    }

    public void setInputStreamCreator(InputStreamCreator is) {
        this.inputStreamCreator = is;
    }

    public InputStream getNewInputStream() throws IOException {
        if (this.inputStreamCreator == null) {
            throw new IllegalStateException("missing input stream creator");
        }
        return this.inputStreamCreator.newInputStream(this);
    }

    public static class MemoryInputStreamCreator
    implements InputStreamCreator {
        private InputStream source;
        private byte[] content;

        public MemoryInputStreamCreator(InputStream source) {
            if (source == null) {
                throw new IllegalArgumentException("source is not defined");
            }
            this.source = source;
        }

        @Override
        public InputStream newInputStream(OutlookMessageAttachment omt) throws IOException {
            if (this.content == null) {
                this.content = IOUtils.toByteArray((InputStream)this.source);
                this.source = null;
            }
            return new ByteArrayInputStream(this.content);
        }
    }

    @FunctionalInterface
    public static interface InputStreamCreator {
        public InputStream newInputStream(OutlookMessageAttachment var1) throws IOException;
    }
}

