/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.jotlmsg.io;

import ch.astorm.jotlmsg.io.FlatEntryStructure;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.poi.util.StringUtil;

public class OneOffEntryIDStructure
extends FlatEntryStructure {
    private static final byte[] FLAGS = new byte[]{0, 0, 0, 0};
    private static final byte[] UUID = new byte[]{-127, 43, 31, -92, -66, -93, 16, 25, -99, 110, 0, -35, 1, 15, 84, 2};
    private static final byte[] VERSION = new byte[]{0, 0};
    private static final byte[] PAD_MAE_FORMAT_M_U_R_L_PAD = new byte[]{1, -112};
    private static final byte[] ADDRESSTYPE = new byte[]{83, 0, 77, 0, 84, 0, 80, 0, 0, 0};
    private String displayName = null;
    private String emailAddress = null;

    public OneOffEntryIDStructure(ByteBuffer bf) {
        super(bf);
        ByteBuffer bf2 = ByteBuffer.wrap(this.getEntryID()).order(ByteOrder.LITTLE_ENDIAN);
        bf2.position(FLAGS.length + UUID.length + VERSION.length + PAD_MAE_FORMAT_M_U_R_L_PAD.length);
        int remaining = bf2.remaining();
        byte[] unicodeLEStrings = new byte[remaining];
        bf2.get(unicodeLEStrings, 0, remaining);
        this.displayName = StringUtil.getFromUnicodeLE0Terminated((byte[])unicodeLEStrings, (int)0, (int)(remaining / 2));
        int offset = this.displayName.length() * 2 + 2;
        String addressType = StringUtil.getFromUnicodeLE0Terminated((byte[])unicodeLEStrings, (int)offset, (int)((remaining - offset) / 2));
        this.emailAddress = StringUtil.getFromUnicodeLE0Terminated((byte[])unicodeLEStrings, (int)(offset += addressType.length() * 2 + 2), (int)((remaining - offset) / 2));
    }

    public OneOffEntryIDStructure(String emailAddress) {
        this(emailAddress, emailAddress);
    }

    public OneOffEntryIDStructure(String displayName, String emailAddress) {
        long totalSize = FLAGS.length + UUID.length + VERSION.length + PAD_MAE_FORMAT_M_U_R_L_PAD.length;
        byte[] displayNameBytes = StringUtil.getToUnicodeLE((String)displayName);
        totalSize += (long)(displayNameBytes.length + 2);
        totalSize += (long)ADDRESSTYPE.length;
        byte[] emailAddressBytes = StringUtil.getToUnicodeLE((String)emailAddress);
        ByteBuffer bf = ByteBuffer.allocate((int)(totalSize += (long)(emailAddressBytes.length + 2))).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(FLAGS).put(UUID).put(VERSION).put(PAD_MAE_FORMAT_M_U_R_L_PAD);
        bf.put(displayNameBytes).put((byte)0).put((byte)0);
        bf.put(ADDRESSTYPE);
        bf.put(emailAddressBytes).put((byte)0).put((byte)0);
        this.setEntryID(bf.array());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }
}

