/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.jotlmsg;

import ch.astorm.jotlmsg.OutlookMessageAttachment;
import ch.astorm.jotlmsg.OutlookMessageRecipient;
import ch.astorm.jotlmsg.io.FlatEntryListStructure;
import ch.astorm.jotlmsg.io.MessagePropertiesChunk;
import ch.astorm.jotlmsg.io.OneOffEntryIDStructure;
import ch.astorm.jotlmsg.io.StoragePropertiesChunk;
import ch.astorm.jotlmsg.io.UncompressedRtfOutputStream;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.datatypes.RecipientChunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.StringUtil;

public class OutlookMessage {
    private static final int RECIPIENT_FLAGS_DISPLAY_NAME_INCLUDED = 16;
    private static final int TRANSMITTABLE_DISPLAY_NAME_SAME_AS_DISPLAY_NAME = 64;
    private static final int RECIPIENT_FLAGS_TYPE_SMTP = 3;
    private static final String RTF_PLACEHOLDER = "#empty";
    private String subject;
    private String plainTextBody;
    private String htmlBody;
    private String from;
    private List<String> replyTo;
    private Date sentDate;
    private final Map<OutlookMessageRecipient.Type, List<OutlookMessageRecipient>> recipients = new EnumMap<OutlookMessageRecipient.Type, List<OutlookMessageRecipient>>(OutlookMessageRecipient.Type.class);
    private final List<OutlookMessageAttachment> attachments = new ArrayList<OutlookMessageAttachment>(8);
    public static final String MIME_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss Z (z)";
    private static final Pattern MIXED_MAIL = Pattern.compile("[^\\s<>,/]+@[^\\s<>,/]+");

    public OutlookMessage() {
    }

    public OutlookMessage(InputStream mapiMessageInputStream) throws IOException {
        this(new MAPIMessage(mapiMessageInputStream));
    }

    public OutlookMessage(File mapiMessageFile) throws IOException {
        this(new MAPIMessage(mapiMessageFile));
    }

    public OutlookMessage(MAPIMessage mapiMessage) {
        this.parseMAPIMessage(mapiMessage);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getPlainTextBody() {
        return this.plainTextBody;
    }

    public void setPlainTextBody(String plainTextBody) {
        this.plainTextBody = plainTextBody;
    }

    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public List<String> getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(List<String> replyTo) {
        this.replyTo = replyTo;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date d) {
        this.sentDate = d;
    }

    public List<OutlookMessageRecipient> getRecipients(OutlookMessageRecipient.Type type) {
        return Collections.unmodifiableList(this.recipients.getOrDefault((Object)type, new ArrayList(0)));
    }

    public List<OutlookMessageRecipient> getAllRecipients() {
        ArrayList<OutlookMessageRecipient> allRecipients = new ArrayList<OutlookMessageRecipient>(16);
        this.recipients.forEach((k, v) -> allRecipients.addAll((Collection<OutlookMessageRecipient>)v));
        return allRecipients;
    }

    public OutlookMessageRecipient addRecipient(OutlookMessageRecipient.Type type, String email) {
        return this.addRecipient(type, email, null);
    }

    public OutlookMessageRecipient addRecipient(OutlookMessageRecipient.Type type, String email, String name) {
        OutlookMessageRecipient recipient = new OutlookMessageRecipient(type, email, name);
        this.addRecipient(recipient);
        return recipient;
    }

    public void addRecipient(OutlookMessageRecipient recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("recipient is not defined");
        }
        List<OutlookMessageRecipient> typeRecipients = this.recipients.get((Object)recipient.getType());
        if (typeRecipients == null) {
            typeRecipients = new ArrayList<OutlookMessageRecipient>(31);
            this.recipients.put(recipient.getType(), typeRecipients);
        }
        typeRecipients.add(recipient);
    }

    public void removeRecipient(OutlookMessageRecipient recipient) {
        List<OutlookMessageRecipient> typeRecipients = this.recipients.get((Object)recipient.getType());
        if (typeRecipients != null) {
            typeRecipients.remove(recipient);
        }
    }

    public void removeAllRecipients(OutlookMessageRecipient.Type type) {
        this.recipients.remove((Object)type);
    }

    public void removeAllRecipients() {
        this.recipients.clear();
    }

    public List<OutlookMessageAttachment> getAttachments() {
        return this.attachments;
    }

    public OutlookMessageAttachment addAttachment(String name, String mimeType, InputStream input) {
        OutlookMessageAttachment attachment = new OutlookMessageAttachment(name, mimeType, input);
        this.addAttachment(attachment);
        return attachment;
    }

    public OutlookMessageAttachment addAttachment(String name, String mimeType, OutlookMessageAttachment.InputStreamCreator inputStreamCreator) {
        OutlookMessageAttachment attachment = new OutlookMessageAttachment(name, mimeType, inputStreamCreator);
        this.addAttachment(attachment);
        return attachment;
    }

    public void addAttachment(OutlookMessageAttachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment is not defined");
        }
        this.attachments.add(attachment);
    }

    public void removeAttachment(OutlookMessageAttachment attachment) {
        this.attachments.remove(attachment);
    }

    public void removeAllAttachments() {
        this.attachments.clear();
    }

    public MimeMessage toMimeMessage() throws IOException, MessagingException {
        return this.toMimeMessage(new Properties());
    }

    public MimeMessage toMimeMessage(Properties sessionProps) throws IOException, MessagingException {
        Session session = Session.getInstance((Properties)sessionProps);
        return this.toMimeMessage(session);
    }

    public MimeMessage toMimeMessage(Session session) throws IOException, MessagingException {
        MimeBodyPart combinedBodiesPart;
        List<String> replyTo;
        String from;
        MimeMessage message = new MimeMessage(session);
        message.setSentDate(this.sentDate);
        String subject = this.getSubject();
        if (subject != null) {
            message.setSubject(subject);
        }
        if ((from = OutlookMessage.extractEmail(this.getFrom())) != null) {
            message.setFrom((Address)new InternetAddress(from));
        }
        if ((replyTo = this.getReplyTo()) != null) {
            ArrayList replyAddresses = new ArrayList(replyTo.size());
            for (String replyToEmail : replyTo) {
                String replyToEmailExtracted = OutlookMessage.extractEmail(replyToEmail);
                if (replyToEmailExtracted == null) continue;
                replyAddresses.add(new InternetAddress(replyToEmailExtracted));
            }
            message.setReplyTo(replyAddresses.toArray(new Address[replyAddresses.size()]));
        }
        for (OutlookMessageRecipient recipient : this.getAllRecipients()) {
            Address address = recipient.getAddress();
            if (address == null) continue;
            message.addRecipient(recipient.getType().getRecipientType(), address);
        }
        String plainText = this.getPlainTextBody();
        String html = this.getHtmlBody();
        if (plainText == null && html == null) {
            throw new MessagingException("missing body");
        }
        List<OutlookMessageAttachment> regularAttachments = this.getAttachments().stream().filter(att -> att.getContentId() == null).toList();
        List<OutlookMessageAttachment> inlineAttachments = this.getAttachments().stream().filter(att -> att.getContentId() != null).toList();
        MimeMultipart multipart = new MimeMultipart();
        ArrayList<MimeBodyPart> bodies = new ArrayList<MimeBodyPart>();
        if (plainText != null) {
            MimeBodyPart plainBody = new MimeBodyPart();
            plainBody.setText(plainText, StandardCharsets.UTF_8.name(), "plain");
            bodies.add(plainBody);
        }
        if (html != null) {
            MimeBodyPart htmlBody = new MimeBodyPart();
            htmlBody.setText(this.getHtmlBody(), StandardCharsets.UTF_8.name(), "html");
            bodies.add(htmlBody);
        }
        if (bodies.size() > 1) {
            MimeMultipart alternativePart = new MimeMultipart("alternative");
            for (MimeBodyPart body : bodies) {
                alternativePart.addBodyPart((BodyPart)body);
            }
            combinedBodiesPart = new MimeBodyPart();
            combinedBodiesPart.setContent((Multipart)alternativePart);
        } else {
            combinedBodiesPart = (MimeBodyPart)bodies.get(0);
        }
        if (inlineAttachments.isEmpty()) {
            multipart.addBodyPart((BodyPart)combinedBodiesPart);
        } else {
            MimeMultipart relatedPart = new MimeMultipart("related");
            relatedPart.addBodyPart((BodyPart)combinedBodiesPart);
            for (OutlookMessageAttachment attachment : inlineAttachments) {
                String name = attachment.getName();
                String mimeType = attachment.getMimeType();
                byte[] data = this.readAttachement(attachment);
                String contentId = attachment.getContentId();
                MimeBodyPart part = new MimeBodyPart();
                part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, mimeType)));
                part.setContentID(contentId);
                part.setHeader("Content-Disposition", "inline");
                part.setFileName(name);
                relatedPart.addBodyPart((BodyPart)part);
            }
            MimeBodyPart relatedBodyPart = new MimeBodyPart();
            relatedBodyPart.setContent((Multipart)relatedPart);
            multipart.addBodyPart((BodyPart)relatedBodyPart);
        }
        for (OutlookMessageAttachment attachment : regularAttachments) {
            String name = attachment.getName();
            String mimeType = attachment.getMimeType();
            byte[] data = this.readAttachement(attachment);
            String contentId = attachment.getContentId();
            MimeBodyPart part = new MimeBodyPart();
            part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, mimeType)));
            if (contentId != null) {
                part.setContentID(contentId);
                part.setHeader("Content-Disposition", "inline");
            }
            part.setFileName(name);
            multipart.addBodyPart((BodyPart)part);
        }
        message.setContent((Multipart)multipart);
        return message;
    }

    public static String extractEmail(String mixedMailStr) {
        if (mixedMailStr == null || mixedMailStr.trim().isEmpty()) {
            return null;
        }
        Matcher matcher = MIXED_MAIL.matcher(mixedMailStr);
        return matcher.find() ? matcher.group() : null;
    }

    public void writeTo(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.writeTo(fos);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        DirectoryEntry recip;
        String rid;
        POIFSFileSystem fs = new POIFSFileSystem();
        List<OutlookMessageRecipient> recipients = this.getAllRecipients();
        List<OutlookMessageAttachment> attachments = this.getAttachments();
        List<String> replyToRecipents = this.getReplyTo();
        String plainTextBody = this.getPlainTextBody();
        String htmlBody = this.getHtmlBody();
        String subject = this.getSubject();
        String from = this.getFrom();
        String rtfBody = htmlBody != null ? RTF_PLACEHOLDER : null;
        DirectoryEntry nameid = fs.createDirectory("__nameid_version1.0");
        nameid.createDocument("__substg1.0_00020102", (InputStream)new ByteArrayInputStream(new byte[0]));
        nameid.createDocument("__substg1.0_00030102", (InputStream)new ByteArrayInputStream(new byte[0]));
        nameid.createDocument("__substg1.0_00040102", (InputStream)new ByteArrayInputStream(new byte[0]));
        MessagePropertiesChunk topLevelChunk = new MessagePropertiesChunk();
        topLevelChunk.setAttachmentCount(attachments.size());
        topLevelChunk.setRecipientCount(recipients.size());
        topLevelChunk.setNextAttachmentId(attachments.size());
        topLevelChunk.setNextRecipientId(recipients.size());
        topLevelChunk.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.STORE_SUPPORT_MASK, 262144));
        topLevelChunk.setProperty(new PropertyValue(MAPIProperty.MESSAGE_CLASS, 6L, StringUtil.getToUnicodeLE((String)"IPM.Note")));
        topLevelChunk.setProperty((PropertyValue)this.createBooleanPropertyValue(MAPIProperty.HASATTACH, !attachments.isEmpty()));
        if (this.sentDate == null) {
            topLevelChunk.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.MESSAGE_FLAGS, 8));
        } else {
            SimpleDateFormat mdf = new SimpleDateFormat(MIME_DATE_FORMAT);
            topLevelChunk.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.MESSAGE_FLAGS, 2));
            topLevelChunk.setProperty((PropertyValue)this.createTimePropertyValue(MAPIProperty.CLIENT_SUBMIT_TIME, this.sentDate));
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.TRANSPORT_MESSAGE_HEADERS, 6L, StringUtil.getToUnicodeLE((String)("Date: " + mdf.format(this.sentDate)))));
        }
        if (subject != null) {
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.SUBJECT, 6L, StringUtil.getToUnicodeLE((String)subject)));
        }
        if (plainTextBody != null) {
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.BODY, 6L, StringUtil.getToUnicodeLE((String)plainTextBody)));
        }
        if (rtfBody != null) {
            ByteArrayOutputStream compressedRtf = new ByteArrayOutputStream();
            try (UncompressedRtfOutputStream uncompressedRtfOutputStream = new UncompressedRtfOutputStream(compressedRtf);){
                IOUtils.copy((InputStream)new ByteArrayInputStream(rtfBody.getBytes(StandardCharsets.UTF_8)), (OutputStream)uncompressedRtfOutputStream);
            }
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.RTF_COMPRESSED, 6L, compressedRtf.toByteArray(), Types.BINARY));
            topLevelChunk.setProperty((PropertyValue)this.createBooleanPropertyValue(MAPIProperty.RTF_IN_SYNC, false));
        }
        if (htmlBody != null) {
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.BODY_HTML, 6L, htmlBody.getBytes(StandardCharsets.UTF_8), Types.BINARY));
            topLevelChunk.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.INTERNET_CPID, 65001));
        }
        if (from != null) {
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.SENDER_EMAIL_ADDRESS, 6L, StringUtil.getToUnicodeLE((String)from)));
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.SENDER_NAME, 6L, StringUtil.getToUnicodeLE((String)from)));
        }
        if (replyToRecipents != null) {
            FlatEntryListStructure<OneOffEntryIDStructure> fels = new FlatEntryListStructure<OneOffEntryIDStructure>();
            Object replyToRecipentNames = null;
            boolean first = true;
            for (String replyToRecipent : replyToRecipents) {
                if (first) {
                    replyToRecipentNames = new String();
                    first = false;
                } else {
                    replyToRecipentNames = replyToRecipentNames + ";";
                }
                replyToRecipentNames = (String)replyToRecipentNames + replyToRecipent;
                fels.addFlatEntryStructure(new OneOffEntryIDStructure(replyToRecipent));
            }
            if (replyToRecipentNames != null && fels.getCount() > 0L) {
                topLevelChunk.setProperty(new PropertyValue(MAPIProperty.REPLY_RECIPIENT_ENTRIES, 6L, fels.toBytes()));
                topLevelChunk.setProperty(new PropertyValue(MAPIProperty.REPLY_RECIPIENT_NAMES, 6L, StringUtil.getToUnicodeLE((String)replyToRecipentNames)));
            }
        }
        topLevelChunk.writeTo((DirectoryEntry)fs.getRoot());
        int recipientCounter = 0;
        for (OutlookMessageRecipient recipient : recipients) {
            if (recipientCounter >= 2048) {
                throw new RuntimeException("too many recipients (max=2048)");
            }
            String name = recipient.getName();
            String email = recipient.getEmail();
            OutlookMessageRecipient.Type type = recipient.getType();
            int rt = type == OutlookMessageRecipient.Type.TO ? 1 : (type == OutlookMessageRecipient.Type.CC ? 2 : 3);
            StoragePropertiesChunk recipStorage = new StoragePropertiesChunk();
            recipStorage.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.RECIPIENT_FLAGS, 83));
            recipStorage.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.OBJECT_TYPE, 6));
            recipStorage.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.DISPLAY_TYPE, 0));
            recipStorage.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.RECIPIENT_TYPE, rt));
            recipStorage.setProperty(new PropertyValue(MAPIProperty.ADDRTYPE, 6L, StringUtil.getToUnicodeLE((String)"SMTP")));
            recipStorage.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.ROWID, recipientCounter));
            if (name != null) {
                recipStorage.setProperty(new PropertyValue(MAPIProperty.DISPLAY_NAME, 6L, StringUtil.getToUnicodeLE((String)name)));
                recipStorage.setProperty(new PropertyValue(MAPIProperty.TRANSMITABLE_DISPLAY_NAME, 6L, StringUtil.getToUnicodeLE((String)name)));
                recipStorage.setProperty(new PropertyValue(MAPIProperty.RECIPIENT_DISPLAY_NAME, 6L, StringUtil.getToUnicodeLE((String)name)));
            }
            if (email != null) {
                recipStorage.setProperty(new PropertyValue(MAPIProperty.EMAIL_ADDRESS, 6L, StringUtil.getToUnicodeLE((String)email)));
                if (name == null) {
                    recipStorage.setProperty(new PropertyValue(MAPIProperty.DISPLAY_NAME, 6L, StringUtil.getToUnicodeLE((String)email)));
                    recipStorage.setProperty(new PropertyValue(MAPIProperty.RECIPIENT_DISPLAY_NAME, 6L, StringUtil.getToUnicodeLE((String)email)));
                }
            }
            OneOffEntryIDStructure oneOffEntryIDStructure = new OneOffEntryIDStructure(name != null ? name : "", email != null ? email : "");
            recipStorage.setProperty(new PropertyValue(MAPIProperty.ENTRY_ID, 6L, oneOffEntryIDStructure.getEntryID()));
            recipStorage.setProperty(new PropertyValue(MAPIProperty.RECIPIENT_ENTRY_ID, 6L, oneOffEntryIDStructure.getEntryID(), Types.BINARY));
            rid = Integer.toHexString(recipientCounter);
            while (rid.length() < 8) {
                rid = "0" + (String)rid;
            }
            recip = fs.createDirectory("__recip_version1.0_#" + (String)rid);
            recipStorage.writeTo(recip);
            ++recipientCounter;
        }
        int attachmentCounter = 0;
        for (OutlookMessageAttachment attachment : attachments) {
            if (attachmentCounter >= 2048) {
                throw new RuntimeException("too many attachments (max=2048)");
            }
            String name = attachment.getName();
            String mimeType = attachment.getMimeType();
            String contentId = attachment.getContentId();
            byte[] data = this.readAttachement(attachment);
            StoragePropertiesChunk attachStorage = new StoragePropertiesChunk();
            attachStorage.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.OBJECT_TYPE, 7));
            if (name != null) {
                attachStorage.setProperty(new PropertyValue(MAPIProperty.ATTACH_FILENAME, 6L, StringUtil.getToUnicodeLE((String)name)));
                attachStorage.setProperty(new PropertyValue(MAPIProperty.ATTACH_LONG_FILENAME, 6L, StringUtil.getToUnicodeLE((String)name)));
            }
            if (mimeType != null) {
                attachStorage.setProperty(new PropertyValue(MAPIProperty.ATTACH_MIME_TAG, 6L, StringUtil.getToUnicodeLE((String)mimeType)));
            }
            if (contentId != null) {
                attachStorage.setProperty(new PropertyValue(MAPIProperty.ATTACH_CONTENT_ID, 6L, StringUtil.getToUnicodeLE((String)contentId), Types.UNICODE_STRING));
                attachStorage.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.ATTACH_FLAGS, 4));
            }
            attachStorage.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.ATTACH_NUM, attachmentCounter));
            attachStorage.setProperty((PropertyValue)this.createLongPropertyValue(MAPIProperty.ATTACH_METHOD, 1));
            attachStorage.setProperty(new PropertyValue(MAPIProperty.ATTACH_DATA, 6L, data));
            rid = Integer.toHexString(attachmentCounter);
            while (rid.length() < 8) {
                rid = "0" + rid;
            }
            recip = fs.createDirectory("__attach_version1.0_#" + rid);
            attachStorage.writeTo(recip);
            ++attachmentCounter;
        }
        fs.writeFilesystem(outputStream);
        fs.close();
    }

    private byte[] readAttachement(OutlookMessageAttachment attachment) throws IOException {
        try (InputStream is = attachment.getNewInputStream();){
            if (is == null) {
                throw new IllegalStateException("null inputstream for attachement " + attachment.getName() + " (" + attachment.getMimeType() + ")");
            }
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    private PropertyValue.BooleanPropertyValue createBooleanPropertyValue(MAPIProperty property, boolean value) {
        PropertyValue.BooleanPropertyValue propertyValue = new PropertyValue.BooleanPropertyValue(property, 6L, new byte[2]);
        propertyValue.setValue(value);
        return propertyValue;
    }

    private PropertyValue.LongPropertyValue createLongPropertyValue(MAPIProperty property, int value) {
        PropertyValue.LongPropertyValue propertyValue = new PropertyValue.LongPropertyValue(property, 6L, new byte[4]);
        propertyValue.setValue(value);
        return propertyValue;
    }

    private PropertyValue.TimePropertyValue createTimePropertyValue(MAPIProperty property, Date value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        return this.createTimePropertyValue(property, calendar);
    }

    private PropertyValue.TimePropertyValue createTimePropertyValue(MAPIProperty property, Calendar value) {
        PropertyValue.TimePropertyValue propertyValue = new PropertyValue.TimePropertyValue(property, 6L, new byte[8]);
        propertyValue.setValue(value);
        return propertyValue;
    }

    private void parseMAPIMessage(MAPIMessage mapiMessage) {
        this.silent(() -> this.parseHeaders(mapiMessage));
        this.silent(() -> this.parseFrom(mapiMessage));
        this.silent(() -> this.parseReplyTo(mapiMessage));
        this.silent(() -> this.parseSubject(mapiMessage));
        this.silent(() -> this.parseTextBody(mapiMessage));
        this.silent(() -> this.parseHtmlBody(mapiMessage));
        this.silent(() -> this.parseRecipients(mapiMessage));
        this.silent(() -> this.parseAttachments(mapiMessage));
    }

    protected void parseFrom(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        this.from = mapiMessage.getDisplayFrom();
        if (this.from != null) {
            this.from = this.from.trim();
        }
        if (this.from != null && this.from.isEmpty()) {
            this.from = null;
        }
    }

    protected void parseReplyTo(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        byte[] replyToRecipentBytes = null;
        List replyEntriesChunks = (List)mapiMessage.getMainChunks().getAll().get(MAPIProperty.REPLY_RECIPIENT_ENTRIES);
        if (replyEntriesChunks != null && !replyEntriesChunks.isEmpty()) {
            for (Chunk chunk : replyEntriesChunks) {
                if (!(chunk instanceof ByteChunk)) continue;
                ByteChunk bc = (ByteChunk)chunk;
                replyToRecipentBytes = bc.getValue();
            }
        }
        if (replyToRecipentBytes != null) {
            FlatEntryListStructure<OneOffEntryIDStructure> fels = new FlatEntryListStructure<OneOffEntryIDStructure>(OneOffEntryIDStructure.class, replyToRecipentBytes);
            ArrayList<String> replyToRecipents = new ArrayList<String>();
            for (OneOffEntryIDStructure ooes : fels) {
                replyToRecipents.add(ooes.getEmailAddress());
            }
            this.setReplyTo(replyToRecipents);
        }
    }

    protected void parseSubject(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        this.subject = mapiMessage.getSubject();
        if (this.subject != null) {
            this.subject = this.subject.trim();
        }
        if (this.subject != null && this.subject.isEmpty()) {
            this.subject = null;
        }
    }

    protected void parseTextBody(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        this.plainTextBody = mapiMessage.getTextBody();
        if (this.plainTextBody != null) {
            this.plainTextBody = this.plainTextBody.trim();
        }
        if (this.plainTextBody != null && this.plainTextBody.isEmpty()) {
            this.plainTextBody = null;
        }
    }

    protected void parseHtmlBody(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        this.htmlBody = mapiMessage.getHtmlBody();
        if (this.htmlBody != null) {
            this.htmlBody = this.htmlBody.trim();
        }
        if (this.htmlBody != null && this.htmlBody.isEmpty()) {
            this.htmlBody = null;
        }
    }

    protected void parseRecipients(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        RecipientChunks[] recipientChunks;
        for (RecipientChunks recipientChunk : recipientChunks = mapiMessage.getRecipientDetailsChunks()) {
            String name = recipientChunk.getRecipientName();
            String email = recipientChunk.getRecipientEmailAddress();
            if (name != null && email != null && name.equals(email)) {
                name = null;
            }
            OutlookMessageRecipient.Type type = OutlookMessageRecipient.Type.TO;
            List values = (List)recipientChunk.getProperties().get(MAPIProperty.RECIPIENT_TYPE);
            if (values != null && !values.isEmpty()) {
                int value = (Integer)((PropertyValue)values.get(0)).getValue();
                if (value == 1) {
                    type = OutlookMessageRecipient.Type.TO;
                } else if (value == 2) {
                    type = OutlookMessageRecipient.Type.CC;
                } else if (value == 3) {
                    type = OutlookMessageRecipient.Type.BCC;
                }
            }
            this.addRecipient(type, email, name);
        }
    }

    protected void parseHeaders(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        List headerChunks = (List)mapiMessage.getMainChunks().getAll().get(MAPIProperty.TRANSPORT_MESSAGE_HEADERS);
        if (headerChunks != null && !headerChunks.isEmpty()) {
            for (Chunk chunk : headerChunks) {
                StringChunk sc;
                String value;
                int dateIdx;
                if (!(chunk instanceof StringChunk) || (dateIdx = (value = (sc = (StringChunk)chunk).getValue()).indexOf("Date:")) < 0) continue;
                int line = value.indexOf(10, dateIdx + 5);
                int semiColon = value.indexOf(59, dateIdx + 5);
                int limit = line >= 0 && semiColon >= 0 ? Math.min(line, semiColon) : (line >= 0 ? line : semiColon);
                String dateStr = value.substring(dateIdx + 5, limit >= 0 ? limit : value.length()).trim();
                SimpleDateFormat mdf = new SimpleDateFormat(MIME_DATE_FORMAT);
                try {
                    this.sentDate = mdf.parse(dateStr);
                }
                catch (ParseException parseException) {}
            }
        }
        if (this.sentDate == null) {
            Calendar msgDate = mapiMessage.getMessageDate();
            this.sentDate = msgDate.getTime();
        }
    }

    protected void parseAttachments(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        AttachmentChunks[] attachmentChunks;
        for (AttachmentChunks attachmentChunk : attachmentChunks = mapiMessage.getAttachmentFiles()) {
            StringChunk longFileName = attachmentChunk.getAttachLongFileName();
            StringChunk fileName = attachmentChunk.getAttachFileName();
            ByteChunk data = attachmentChunk.getAttachData();
            StringChunk mimeType = attachmentChunk.getAttachMimeTag();
            StringChunk contentId = attachmentChunk.getAttachContentId();
            String name = longFileName != null ? longFileName.getValue() : (fileName != null ? fileName.getValue() : attachmentChunk.getPOIFSName());
            ByteArrayInputStream dataIS = data != null ? new ByteArrayInputStream(data.getValue()) : null;
            String mimeTypeVal = mimeType != null ? mimeType.getValue() : null;
            OutlookMessageAttachment attachment = this.addAttachment(name, mimeTypeVal, dataIS);
            attachment.setContentId(contentId != null ? contentId.getValue() : null);
        }
    }

    private boolean silent(SilentCallFailure call) {
        try {
            call.invoke();
        }
        catch (ChunkNotFoundException ignored) {
            return false;
        }
        return true;
    }

    @FunctionalInterface
    private static interface SilentCallFailure {
        public void invoke() throws ChunkNotFoundException;
    }
}

