/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.jotlmsg;

import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;

public class OutlookMessageRecipient {
    private final Type type;
    private String name;
    private String email;

    public OutlookMessageRecipient(Type type, String email) {
        this(type, email, null);
    }

    public OutlookMessageRecipient(Type type, String email, String name) {
        if (type == null) {
            throw new IllegalArgumentException("type not defined");
        }
        this.type = type;
        this.email = email;
        this.name = name;
    }

    public final Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Address getAddress() throws AddressException {
        if (this.email == null || this.email.isEmpty()) {
            return null;
        }
        return new InternetAddress(this.email);
    }

    public static enum Type {
        TO(Message.RecipientType.TO),
        CC(Message.RecipientType.CC),
        BCC(Message.RecipientType.BCC);

        private Message.RecipientType rt;

        private Type(Message.RecipientType rt) {
            this.rt = rt;
        }

        Message.RecipientType getRecipientType() {
            return this.rt;
        }
    }
}

