/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.jotlmsg.io;

import ch.astorm.jotlmsg.io.FlatEntryStructure;
import ch.astorm.jotlmsg.io.FlatEntryStructureFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FlatEntryListStructure<T extends FlatEntryStructure>
implements Iterable<T> {
    private long count;
    private long size;
    private final FlatEntryStructureFactory<T> fesf = new FlatEntryStructureFactory();
    private List<T> flatEntryStructures = new ArrayList<T>();

    public long getCount() {
        return this.count;
    }

    public long getSize() {
        return this.size;
    }

    public List<T> getFlatEntryStructures() {
        return this.flatEntryStructures;
    }

    public void setFlatEntryStructures(List<T> flatEntries) {
        this.flatEntryStructures = flatEntries;
    }

    public void addFlatEntryStructure(T flatEntry) {
        this.flatEntryStructures.add(flatEntry);
        long totalSize = 0L;
        for (FlatEntryStructure fes : this.flatEntryStructures) {
            totalSize += fes.getSize();
            totalSize += 4L;
            totalSize = totalSize + 4L & 0xFFFFFFFFFFFFFFFCL;
        }
        this.size = totalSize;
        this.count = this.flatEntryStructures.size();
    }

    public FlatEntryListStructure() {
    }

    public FlatEntryListStructure(Class<T> clazz, byte[] bytes) {
        ByteBuffer bf = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        this.count = bf.getInt();
        this.size = bf.getInt();
        int i = 0;
        while ((long)i < this.count) {
            this.flatEntryStructures.add(this.fesf.createFlatEntryStructure(clazz, bf));
            bf.position(bf.position() + 4 & 0xFFFFFFFC);
            ++i;
        }
    }

    public byte[] toBytes() {
        long totalSize = 8L;
        for (FlatEntryStructure fes : this.flatEntryStructures) {
            totalSize += fes.getSize();
            totalSize += 4L;
            totalSize = totalSize + 4L & 0xFFFFFFFFFFFFFFFCL;
        }
        ByteBuffer bf = ByteBuffer.allocate((int)totalSize).order(ByteOrder.LITTLE_ENDIAN);
        bf.putInt(this.flatEntryStructures.size());
        bf.putInt((int)totalSize - 8);
        for (FlatEntryStructure fes : this.flatEntryStructures) {
            bf.putInt((int)fes.getSize());
            bf.put(fes.getEntryID());
            bf.position(bf.position() + 4 & 0xFFFFFFFC);
        }
        this.size = totalSize - 8L;
        return bf.array();
    }

    @Override
    public Iterator<T> iterator() {
        return this.flatEntryStructures.iterator();
    }
}

