/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.jotlmsg.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hmef.CompressedRTF;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public class UncompressedRtfOutputStream
extends FilterOutputStream {
    private static final byte[] CRC_UNCOMPRESSED = new byte[]{0, 0, 0, 0};
    private boolean closed = false;
    private final ByteArrayOutputStream dataBuffer = new ByteArrayOutputStream();
    private int rawSize = 0;

    public UncompressedRtfOutputStream(OutputStream delegate) {
        super(delegate);
    }

    @Override
    public void write(int b) {
        this.dataBuffer.write(b);
        ++this.rawSize;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.writeHeader();
        this.writeData();
        super.close();
    }

    private void writeHeader() throws IOException {
        LittleEndian.putInt((int)(this.dataBuffer.size() + 12), (OutputStream)this.out);
        LittleEndian.putInt((int)this.rawSize, (OutputStream)this.out);
        LittleEndian.putInt((int)CompressedRTF.UNCOMPRESSED_SIGNATURE_INT, (OutputStream)this.out);
        this.out.write(CRC_UNCOMPRESSED);
    }

    private void writeData() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.dataBuffer.toByteArray());
        IOUtils.copy((InputStream)byteArrayInputStream, (OutputStream)this.out);
    }
}

