/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j.protocol;

import ch.astorm.smtp4j.core.SmtpMessage;
import ch.astorm.smtp4j.core.SmtpMessageHandler;
import ch.astorm.smtp4j.protocol.SmtpCommand;
import ch.astorm.smtp4j.protocol.SmtpProtocolConstants;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class SmtpTransactionHandler {
    private Socket socket;
    private Scanner input;
    private PrintWriter output;
    private SmtpMessageHandler handler;
    private String mailFrom;
    private List<String> recipients;
    private StringBuilder smtpMessageContent;

    private SmtpTransactionHandler(Socket socket, Scanner scanner, PrintWriter printWriter, SmtpMessageHandler smtpMessageHandler) {
        this.socket = socket;
        this.input = scanner;
        this.output = printWriter;
        this.handler = smtpMessageHandler;
    }

    public static void handle(Socket socket, Scanner scanner, PrintWriter printWriter, SmtpMessageHandler smtpMessageHandler) throws IOException {
        SmtpTransactionHandler smtpTransactionHandler = new SmtpTransactionHandler(socket, scanner, printWriter, smtpMessageHandler);
        smtpTransactionHandler.execute();
    }

    private void execute() throws IOException {
        this.reply(220, "localhost smtp4j server ready");
        SmtpCommand smtpCommand = SmtpCommand.parse(this.nextLine());
        if (smtpCommand != null) {
            if (smtpCommand.getType() != SmtpCommand.Type.EHLO) {
                this.reply(503, "Bad sequence of command (wrong command)");
                return;
            }
        } else {
            this.reply(503, "Bad sequence of command (no more token)");
            return;
        }
        String string = smtpCommand.getParameter();
        this.reply(250, string != null ? "smtp4j greets " + smtpCommand.getParameter() : "OK");
        this.readTransaction();
    }

    private void readTransaction() throws IOException {
        while (true) {
            String string;
            SmtpCommand smtpCommand = this.nextCommand();
            SmtpCommand.Type type = smtpCommand.getType();
            if (this.mailFrom == null) {
                if (type == SmtpCommand.Type.MAIL_FROM) {
                    string = smtpCommand.getParameter();
                    this.mailFrom = string.substring(1, string.length() - 1);
                    this.reply(250, "OK");
                    continue;
                }
                if (type == SmtpCommand.Type.QUIT) {
                    this.reply(250, "OK");
                    return;
                }
                this.reply(503, "Bad sequence of command (wrong command)");
                continue;
            }
            if (this.recipients == null) {
                if (type != SmtpCommand.Type.RECIPIENT) {
                    this.reply(503, "Bad sequence of command (wrong command)");
                    continue;
                }
                this.recipients = new ArrayList<String>();
                while (type == SmtpCommand.Type.RECIPIENT) {
                    string = smtpCommand.getParameter();
                    this.recipients.add(string.substring(1, string.length() - 1));
                    this.reply(250, "OK");
                    smtpCommand = this.nextCommand();
                    type = smtpCommand.getType();
                }
            }
            if (type == SmtpCommand.Type.DATA) {
                if (this.smtpMessageContent != null) {
                    this.reply(503, "Bad sequence of command (wrong command)");
                    continue;
                }
                this.smtpMessageContent = new StringBuilder(256);
                this.reply(354, null);
                string = this.nextLine();
                while (string != null) {
                    if (string.equals(SmtpProtocolConstants.DOT)) {
                        this.smtpMessageContent.delete(this.smtpMessageContent.length() - SmtpProtocolConstants.CRLF.length(), this.smtpMessageContent.length());
                        break;
                    }
                    this.smtpMessageContent.append(string).append(SmtpProtocolConstants.CRLF);
                    this.reply(250, "OK");
                    string = this.nextLine();
                }
                SmtpMessage smtpMessage = SmtpMessage.create(this.mailFrom, this.recipients, this.smtpMessageContent.toString());
                this.handler.handle(smtpMessage);
                this.reply(250, "OK");
                continue;
            }
            if (type == SmtpCommand.Type.QUIT) {
                this.reply(250, "OK");
                return;
            }
            this.reply(503, "Bad sequence of command (wrong command)");
        }
    }

    private void resetState() {
        this.mailFrom = null;
        this.recipients = null;
        this.smtpMessageContent = null;
    }

    private String nextLine() throws IOException {
        if (!this.input.hasNext()) {
            throw new IOException("Unexpected end of stream (no more token)");
        }
        return this.input.next();
    }

    private SmtpCommand nextCommand() throws IOException {
        SmtpCommand smtpCommand = SmtpCommand.parse(this.nextLine());
        while (smtpCommand != null) {
            SmtpCommand.Type type = smtpCommand.getType();
            if (type == SmtpCommand.Type.NOOP) {
                this.reply(250, "OK");
            } else if (type == SmtpCommand.Type.EXPAND) {
                this.reply(255, "Not supported");
            } else if (type == SmtpCommand.Type.VERIFY) {
                this.reply(255, "Not supported");
            } else if (type == SmtpCommand.Type.HELP) {
                this.reply(255, "Not supported");
            } else if (type == SmtpCommand.Type.UNKNOWN) {
                this.reply(500, "Unknown command");
            } else if (type == SmtpCommand.Type.RESET) {
                this.resetState();
                this.reply(250, "OK");
            } else {
                return smtpCommand;
            }
            if (!this.input.hasNext()) {
                throw new IOException("Unexpected end of stream (no more token)");
            }
            smtpCommand = SmtpCommand.parse(this.nextLine());
        }
        throw new IOException("Unexpected end of stream (no more command)");
    }

    private void reply(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(n);
        if (string != null) {
            stringBuilder.append(SmtpProtocolConstants.SP);
            stringBuilder.append(string);
        }
        stringBuilder.append(SmtpProtocolConstants.CRLF);
        this.output.print(stringBuilder.toString());
        this.output.flush();
    }
}

