/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j.util;

import ch.astorm.smtp4j.SmtpServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class MimeMessageBuilder {
    private MimeMessage message;
    private MimeBodyPart body;
    private List<MimeBodyPart> attachments = new ArrayList<MimeBodyPart>();

    public MimeMessageBuilder(SmtpServer smtpServer) {
        this(smtpServer.createSession());
    }

    public MimeMessageBuilder(Session session) {
        this.message = new MimeMessage(session);
    }

    public MimeMessageBuilder from(String string) throws MessagingException {
        this.checkState();
        this.message.setFrom(string);
        return this;
    }

    public MimeMessageBuilder from(Address address) throws MessagingException {
        this.checkState();
        this.message.setFrom(address);
        return this;
    }

    public MimeMessageBuilder at(String string) throws ParseException, MessagingException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        return this.at(simpleDateFormat.parse(string));
    }

    public MimeMessageBuilder at(Date date) throws MessagingException {
        this.checkState();
        this.message.setSentDate(date);
        return this;
    }

    public MimeMessageBuilder to(String ... stringArray) throws MessagingException {
        for (InternetAddress internetAddress : this.parseAddressList(stringArray)) {
            this.to((Address)internetAddress);
        }
        return this;
    }

    public MimeMessageBuilder to(Address address) throws MessagingException {
        return this.toRecipient(Message.RecipientType.TO, address);
    }

    public MimeMessageBuilder cc(String ... stringArray) throws MessagingException {
        for (Address address : this.parseAddressList(stringArray)) {
            this.cc(address);
        }
        return this;
    }

    public MimeMessageBuilder cc(Address address) throws MessagingException {
        return this.toRecipient(Message.RecipientType.CC, address);
    }

    public MimeMessageBuilder bcc(String ... stringArray) throws MessagingException {
        for (Address address : this.parseAddressList(stringArray)) {
            this.bcc(address);
        }
        return this;
    }

    public MimeMessageBuilder bcc(Address address) throws MessagingException {
        return this.toRecipient(Message.RecipientType.BCC, address);
    }

    public MimeMessageBuilder toRecipient(Message.RecipientType recipientType, String ... stringArray) throws MessagingException {
        for (Address address : this.parseAddressList(stringArray)) {
            this.toRecipient(recipientType, address);
        }
        return this;
    }

    public MimeMessageBuilder toRecipient(Message.RecipientType recipientType, Address address) throws MessagingException {
        this.checkState();
        this.message.addRecipient(recipientType, address);
        return this;
    }

    public MimeMessageBuilder subject(String string) throws MessagingException {
        this.checkState();
        this.message.setSubject(string);
        return this;
    }

    public MimeMessageBuilder subject(String string, Charset charset) throws MessagingException {
        this.checkState();
        this.message.setSubject(string, charset.name());
        return this;
    }

    public MimeMessageBuilder body(String string) throws MessagingException {
        this.checkState();
        this.body = new MimeBodyPart();
        this.body.setText(string);
        return this;
    }

    public MimeMessageBuilder body(String string, Charset charset) throws MessagingException {
        this.checkState();
        this.body = new MimeBodyPart();
        this.body.setText(string, charset.name());
        return this;
    }

    public MimeMessageBuilder attachment(File file) throws MessagingException {
        return this.attachment(file.getName(), file);
    }

    public MimeMessageBuilder attachment(String string, File file) throws MessagingException {
        this.checkState();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
        mimeBodyPart.setFileName(string);
        this.attachments.add(mimeBodyPart);
        return this;
    }

    public MimeMessageBuilder attachment(String string, String string2, InputStream inputStream) throws IOException, MessagingException {
        this.checkState();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(inputStream, string2)));
        mimeBodyPart.setFileName(string);
        this.attachments.add(mimeBodyPart);
        return this;
    }

    public MimeMessage build() throws MessagingException {
        this.checkState();
        MimeMultipart mimeMultipart = new MimeMultipart();
        mimeMultipart.addBodyPart((BodyPart)this.body);
        for (MimeBodyPart mimeBodyPart : this.attachments) {
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        }
        MimeMessage mimeMessage = this.message;
        mimeMessage.setContent((Multipart)mimeMultipart);
        this.message = null;
        return mimeMessage;
    }

    public MimeMessage send() throws MessagingException {
        MimeMessage mimeMessage = this.build();
        Transport.send((Message)mimeMessage);
        return mimeMessage;
    }

    private void checkState() {
        if (this.message == null) {
            throw new IllegalStateException("Message already built");
        }
    }

    protected List<InternetAddress> parseAddressList(String ... stringArray) throws AddressException {
        ArrayList<InternetAddress> arrayList = new ArrayList<InternetAddress>();
        for (String string : stringArray) {
            for (InternetAddress internetAddress : InternetAddress.parse((String)string)) {
                String string2 = internetAddress.getPersonal();
                if (string2 != null) {
                    try {
                        internetAddress.setPersonal(string2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                arrayList.add(internetAddress);
            }
        }
        return arrayList;
    }
}

