/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j.core;

import ch.astorm.smtp4j.core.SmtpAttachment;
import ch.astorm.smtp4j.protocol.SmtpProtocolConstants;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class SmtpMessage {
    private String sourceFrom;
    private List<String> sourceRecipients;
    private MimeMessage mimeMessage;
    private String rawMimeContent;

    public SmtpMessage(String string, List<String> list, MimeMessage mimeMessage, String string2) {
        this.sourceFrom = string;
        this.sourceRecipients = list;
        this.mimeMessage = mimeMessage;
        this.rawMimeContent = string2;
    }

    public String getSourceFrom() {
        return this.sourceFrom;
    }

    public List<String> getSourceRecipients() {
        return this.sourceRecipients;
    }

    public String getFrom() {
        try {
            Address[] addressArray = this.mimeMessage.getFrom();
            if (addressArray == null || addressArray.length == 0) {
                return null;
            }
            return MimeUtility.decodeText((String)this.mimeMessage.getFrom()[0].toString());
        }
        catch (MessagingException | UnsupportedEncodingException throwable) {
            throw new RuntimeException("Unable to retrieve From header", throwable);
        }
    }

    public List<String> getRecipients(Message.RecipientType recipientType) {
        try {
            Address[] addressArray = this.mimeMessage.getRecipients(recipientType);
            if (addressArray == null || addressArray.length == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<String> arrayList = new ArrayList<String>(addressArray.length);
            for (Address address : addressArray) {
                arrayList.add(MimeUtility.decodeText((String)address.toString()));
            }
            return arrayList;
        }
        catch (MessagingException | UnsupportedEncodingException throwable) {
            throw new RuntimeException("Unable to retrieve Recipients " + recipientType, throwable);
        }
    }

    public String getSubject() {
        try {
            return this.mimeMessage.getSubject();
        }
        catch (MessagingException messagingException) {
            throw new RuntimeException("Unable to retrieve Subject header", messagingException);
        }
    }

    public String getBody() {
        try {
            Object object = this.mimeMessage.getContent();
            if (object == null) {
                return null;
            }
            if (object instanceof MimeMultipart) {
                MimeMultipart mimeMultipart = (MimeMultipart)object;
                if (mimeMultipart.getCount() == 0) {
                    throw new IllegalStateException("At least one part expected");
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                    BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                    if (bodyPart.getFileName() != null) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(SmtpProtocolConstants.CRLF);
                    }
                    stringBuilder.append(bodyPart.getContent().toString());
                }
                return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
            }
            return object.toString();
        }
        catch (MessagingException | IOException throwable) {
            throw new RuntimeException("Unable to retrieve content", throwable);
        }
    }

    public List<SmtpAttachment> getAttachments() {
        try {
            Object object = this.mimeMessage.getContent();
            if (object == null) {
                return null;
            }
            if (object instanceof MimeMultipart) {
                MimeMultipart mimeMultipart = (MimeMultipart)object;
                int n = mimeMultipart.getCount();
                if (n == 0) {
                    throw new IllegalStateException("At least one part expected");
                }
                ArrayList<SmtpAttachment> arrayList = new ArrayList<SmtpAttachment>(n);
                for (int i = 0; i < n; ++i) {
                    BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                    String string = bodyPart.getFileName();
                    if (string == null) continue;
                    SmtpAttachment smtpAttachment = new SmtpAttachment(string, bodyPart.getContentType(), () -> bodyPart.getInputStream());
                    arrayList.add(smtpAttachment);
                }
                return arrayList;
            }
            return Collections.EMPTY_LIST;
        }
        catch (MessagingException | IOException throwable) {
            throw new RuntimeException("Unable to retrieve content", throwable);
        }
    }

    public Date getSentDate() {
        try {
            return this.mimeMessage.getSentDate();
        }
        catch (MessagingException messagingException) {
            throw new RuntimeException("Unable to retrieve Sent date", messagingException);
        }
    }

    public MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    public String getRawMimeContent() {
        return this.rawMimeContent;
    }

    public static SmtpMessage create(String string, List<String> list, String string2) {
        MimeMessage mimeMessage;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes(StandardCharsets.UTF_8));){
            mimeMessage = new MimeMessage(null, (InputStream)byteArrayInputStream);
        }
        catch (MessagingException | IOException throwable) {
            throw new RuntimeException("Unable to create MimeMessage from content", throwable);
        }
        return new SmtpMessage(string, list, mimeMessage, string2);
    }
}

