/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j;

import ch.astorm.smtp4j.core.SmtpMessage;
import ch.astorm.smtp4j.core.SmtpMessageHandler;
import ch.astorm.smtp4j.core.SmtpMessageStorage;
import ch.astorm.smtp4j.protocol.SmtpProtocolException;
import ch.astorm.smtp4j.protocol.SmtpTransactionHandler;
import jakarta.mail.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SmtpServer
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(SmtpServer.class.getName());
    private int port;
    private final SmtpMessageStorage localStorage;
    private volatile SmtpMessageHandler messageHandler;
    private volatile ServerSocket serverSocket;
    private Thread localThread;
    public static int DEFAULT_PORT = 25;

    public SmtpServer(int n) {
        this.port = n;
        this.localStorage = new SmtpMessageStorage();
        this.messageHandler = this.localStorage;
    }

    public Properties getSessionProperties() {
        if (this.port <= 0) {
            throw new IllegalStateException("Dynamic port lookup: server must be started");
        }
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", "localhost");
        properties.setProperty("mail.smtp.port", "" + this.port);
        return properties;
    }

    public Session createSession() {
        return Session.getInstance((Properties)this.getSessionProperties());
    }

    public void setMessageHandler(SmtpMessageHandler smtpMessageHandler) {
        this.messageHandler = smtpMessageHandler != null ? smtpMessageHandler : this.localStorage;
    }

    public SmtpMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SmtpMessage> getReceivedMessages() {
        SmtpMessageStorage smtpMessageStorage = this.localStorage;
        synchronized (smtpMessageStorage) {
            return this.localStorage.getMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReceivedMessages() {
        SmtpMessageStorage smtpMessageStorage = this.localStorage;
        synchronized (smtpMessageStorage) {
            this.localStorage.clear();
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean isClosed() {
        return this.serverSocket == null;
    }

    public synchronized void start() throws IOException {
        if (!this.isClosed()) {
            throw new IllegalStateException("Server already started");
        }
        if (this.port <= 0) {
            this.serverSocket = this.createSocketIfPossible(DEFAULT_PORT);
            if (this.serverSocket != null) {
                this.port = DEFAULT_PORT;
            } else {
                for (int i = 1024; this.serverSocket == null && i < 65536; ++i) {
                    this.serverSocket = this.createSocketIfPossible(i);
                    if (this.serverSocket == null) continue;
                    this.port = i;
                }
            }
            if (this.serverSocket == null) {
                throw new IOException("Unable to start SMTP server (no free port found)");
            }
        } else {
            this.serverSocket = new ServerSocket(this.port);
        }
        this.localThread = new Thread(new SmtpPacketListener());
        this.localThread.start();
    }

    private ServerSocket createSocketIfPossible(int n) {
        try {
            return new ServerSocket(n);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        ServerSocket serverSocket = this.serverSocket;
        this.serverSocket = null;
        serverSocket.close();
        try {
            this.localThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.localThread = null;
    }

    private class SmtpPacketListener
    implements Runnable {
        private SmtpPacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (SmtpServer.this.serverSocket != null) {
                try {
                    Socket socket = SmtpServer.this.serverSocket.accept();
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.ISO_8859_1));
                         PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.ISO_8859_1));){
                        SmtpMessageStorage smtpMessageStorage = SmtpServer.this.localStorage;
                        synchronized (smtpMessageStorage) {
                            SmtpTransactionHandler.handle(socket, bufferedReader, printWriter, SmtpServer.this.messageHandler);
                        }
                    }
                    finally {
                        if (socket == null) continue;
                        socket.close();
                    }
                }
                catch (SmtpProtocolException smtpProtocolException) {
                    LOG.log(Level.WARNING, "Protocol Exception", smtpProtocolException);
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINER, "I/O Exception", iOException);
                }
            }
        }
    }
}

