/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j.core;

import ch.astorm.smtp4j.SmtpServer;
import ch.astorm.smtp4j.core.SmtpMessage;
import ch.astorm.smtp4j.core.SmtpMessageHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultSmtpMessageHandler
implements SmtpMessageHandler {
    private final List<SmtpMessage> messages = new ArrayList<SmtpMessage>(32);
    private volatile boolean serverStarted;

    @Override
    public void notifyStart(SmtpServer smtpServer) {
        this.serverStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyClose(SmtpServer smtpServer) {
        List<SmtpMessage> list = this.messages;
        synchronized (list) {
            this.serverStarted = false;
            this.messages.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMessage(SmtpServer smtpServer, SmtpMessage smtpMessage) {
        List<SmtpMessage> list = this.messages;
        synchronized (list) {
            this.messages.add(smtpMessage);
            this.messages.notifyAll();
        }
    }

    @Override
    public SmtpMessageHandler.SmtpMessageReader messageReader() {
        return new SmtpMessageHandler.SmtpMessageReader(){
            private List<SmtpMessage> localMessages = Collections.EMPTY_LIST;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SmtpMessage readMessage() {
                if (!this.localMessages.isEmpty()) {
                    return this.localMessages.remove(0);
                }
                List<SmtpMessage> list = DefaultSmtpMessageHandler.this.messages;
                synchronized (list) {
                    this.localMessages = DefaultSmtpMessageHandler.this.readMessages();
                    while (DefaultSmtpMessageHandler.this.serverStarted && this.localMessages.isEmpty()) {
                        try {
                            DefaultSmtpMessageHandler.this.messages.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.localMessages = DefaultSmtpMessageHandler.this.readMessages();
                    }
                }
                return !this.localMessages.isEmpty() ? this.localMessages.remove(0) : null;
            }

            @Override
            public void close() throws Exception {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SmtpMessage> readMessages() {
        if (!this.serverStarted) {
            return Collections.EMPTY_LIST;
        }
        List<SmtpMessage> list = this.messages;
        synchronized (list) {
            ArrayList<SmtpMessage> arrayList = new ArrayList<SmtpMessage>(this.messages);
            this.messages.clear();
            return arrayList;
        }
    }
}

