/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j.protocol;

import ch.astorm.smtp4j.core.SmtpMessage;
import ch.astorm.smtp4j.protocol.SmtpCommand;
import ch.astorm.smtp4j.protocol.SmtpProtocolConstants;
import ch.astorm.smtp4j.protocol.SmtpProtocolException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class SmtpTransactionHandler {
    private Socket socket;
    private BufferedReader input;
    private PrintWriter output;
    private MessageReceiver messageReceiver;
    private String mailFrom;
    private List<String> recipients;
    private StringBuilder smtpMessageContent;

    private SmtpTransactionHandler(Socket socket, BufferedReader bufferedReader, PrintWriter printWriter, MessageReceiver messageReceiver) {
        this.socket = socket;
        this.input = bufferedReader;
        this.output = printWriter;
        this.messageReceiver = messageReceiver;
    }

    public static void handle(Socket socket, BufferedReader bufferedReader, PrintWriter printWriter, MessageReceiver messageReceiver) throws IOException, SmtpProtocolException {
        SmtpTransactionHandler smtpTransactionHandler = new SmtpTransactionHandler(socket, bufferedReader, printWriter, messageReceiver);
        smtpTransactionHandler.execute();
    }

    private void execute() throws SmtpProtocolException {
        this.reply(220, "localhost smtp4j server ready");
        SmtpCommand smtpCommand = SmtpCommand.parse(this.nextLine());
        if (smtpCommand != null) {
            if (smtpCommand.getType() != SmtpCommand.Type.EHLO) {
                this.reply(503, "Bad sequence of command (wrong command)");
                return;
            }
        } else {
            this.reply(503, "Bad sequence of command (no more token)");
            return;
        }
        String string = smtpCommand.getParameter();
        this.reply(250, (String)(string != null ? "smtp4j greets " + smtpCommand.getParameter() : "OK"));
        this.readTransaction();
    }

    private void readTransaction() throws SmtpProtocolException {
        while (true) {
            String string;
            SmtpCommand smtpCommand = this.nextCommand();
            SmtpCommand.Type type = smtpCommand.getType();
            if (this.mailFrom == null) {
                if (type == SmtpCommand.Type.MAIL_FROM) {
                    string = smtpCommand.getParameter();
                    this.mailFrom = string.substring(1, string.length() - 1);
                    this.reply(250, "OK");
                    continue;
                }
                if (type == SmtpCommand.Type.QUIT) {
                    this.reply(250, "OK");
                    return;
                }
                this.reply(503, "Bad sequence of command (wrong command)");
                continue;
            }
            if (this.recipients == null) {
                if (type != SmtpCommand.Type.RECIPIENT) {
                    this.reply(503, "Bad sequence of command (wrong command)");
                    continue;
                }
                this.recipients = new ArrayList<String>();
                while (type == SmtpCommand.Type.RECIPIENT) {
                    string = smtpCommand.getParameter();
                    this.recipients.add(string.substring(1, string.length() - 1));
                    this.reply(250, "OK");
                    smtpCommand = this.nextCommand();
                    type = smtpCommand.getType();
                }
            }
            if (type == SmtpCommand.Type.DATA) {
                if (this.smtpMessageContent != null) {
                    this.reply(503, "Bad sequence of command (wrong command)");
                    continue;
                }
                this.smtpMessageContent = new StringBuilder(256);
                this.reply(354, null);
                string = this.nextLine();
                while (string != null) {
                    if (string.equals(SmtpProtocolConstants.DOT)) {
                        this.smtpMessageContent.delete(this.smtpMessageContent.length() - SmtpProtocolConstants.CRLF.length(), this.smtpMessageContent.length());
                        break;
                    }
                    if (string.startsWith(SmtpProtocolConstants.DOT)) {
                        string = string.substring(1);
                    }
                    this.smtpMessageContent.append(string).append(SmtpProtocolConstants.CRLF);
                    string = this.nextLine();
                }
                SmtpMessage smtpMessage = SmtpMessage.create(this.mailFrom, this.recipients, this.smtpMessageContent.toString());
                this.messageReceiver.receiveMessage(smtpMessage);
                this.reply(250, "OK");
                continue;
            }
            if (type == SmtpCommand.Type.QUIT) {
                this.reply(250, "OK");
                return;
            }
            this.reply(503, "Bad sequence of command (wrong command)");
        }
    }

    private void resetState() {
        this.mailFrom = null;
        this.recipients = null;
        this.smtpMessageContent = null;
    }

    private String nextLine() throws SmtpProtocolException {
        try {
            String string = this.input.readLine();
            if (string == null) {
                throw new SmtpProtocolException("Unexpected end of stream (no more line)");
            }
            return string;
        }
        catch (IOException iOException) {
            throw new SmtpProtocolException("I/O exception", iOException);
        }
    }

    private SmtpCommand nextCommand() throws SmtpProtocolException {
        SmtpCommand smtpCommand = SmtpCommand.parse(this.nextLine());
        while (smtpCommand != null) {
            SmtpCommand.Type type = smtpCommand.getType();
            if (type == SmtpCommand.Type.NOOP) {
                this.reply(250, "OK");
            } else if (type == SmtpCommand.Type.EXPAND) {
                this.reply(255, "Not supported");
            } else if (type == SmtpCommand.Type.VERIFY) {
                this.reply(255, "Not supported");
            } else if (type == SmtpCommand.Type.HELP) {
                this.reply(255, "Not supported");
            } else if (type == SmtpCommand.Type.UNKNOWN) {
                this.reply(500, "Unknown command");
            } else if (type == SmtpCommand.Type.RESET) {
                this.resetState();
                this.reply(250, "OK");
            } else {
                return smtpCommand;
            }
            smtpCommand = SmtpCommand.parse(this.nextLine());
        }
        throw new SmtpProtocolException("Unexpected end of exchange (no more command)");
    }

    private void reply(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(n);
        if (string != null) {
            stringBuilder.append(SmtpProtocolConstants.SP);
            stringBuilder.append(string);
        }
        stringBuilder.append(SmtpProtocolConstants.CRLF);
        this.output.print(stringBuilder.toString());
        this.output.flush();
    }

    @FunctionalInterface
    public static interface MessageReceiver {
        public void receiveMessage(SmtpMessage var1);
    }
}

