/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j.protocol;

import ch.astorm.smtp4j.core.SmtpMessage;
import ch.astorm.smtp4j.protocol.SmtpCommand;
import ch.astorm.smtp4j.protocol.SmtpExchange;
import ch.astorm.smtp4j.protocol.SmtpProtocolConstants;
import ch.astorm.smtp4j.protocol.SmtpProtocolException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class SmtpTransactionHandler {
    private final BufferedReader input;
    private final PrintWriter output;
    private final MessageReceiver messageReceiver;
    private String mailFrom;
    private List<String> recipients;
    private StringBuilder smtpMessageContent;
    private final List<String> readData = new ArrayList<String>(64);
    private final List<SmtpExchange> exchanges = new ArrayList<SmtpExchange>(32);

    private SmtpTransactionHandler(BufferedReader bufferedReader, PrintWriter printWriter, MessageReceiver messageReceiver) {
        this.input = bufferedReader;
        this.output = printWriter;
        this.messageReceiver = messageReceiver;
    }

    public static void handle(BufferedReader bufferedReader, PrintWriter printWriter, MessageReceiver messageReceiver) throws IOException, SmtpProtocolException {
        SmtpTransactionHandler smtpTransactionHandler = new SmtpTransactionHandler(bufferedReader, printWriter, messageReceiver);
        smtpTransactionHandler.execute();
    }

    private void execute() throws SmtpProtocolException {
        this.reply(220, "localhost smtp4j server ready");
        SmtpCommand smtpCommand = SmtpCommand.parse(this.nextLine());
        if (smtpCommand != null) {
            if (smtpCommand.getType() != SmtpCommand.Type.EHLO) {
                this.reply(503, "Bad sequence of command (wrong command)");
                return;
            }
        } else {
            this.reply(503, "Bad sequence of command (no more token)");
            return;
        }
        String string = smtpCommand.getParameter();
        this.reply(250, (String)(string != null ? "smtp4j greets " + smtpCommand.getParameter() : "OK"));
        this.readTransaction();
    }

    private void readTransaction() throws SmtpProtocolException {
        Object object;
        while (true) {
            String string;
            object = this.nextCommand();
            SmtpCommand.Type type = ((SmtpCommand)object).getType();
            if (this.mailFrom == null) {
                if (type == SmtpCommand.Type.MAIL_FROM) {
                    string = ((SmtpCommand)object).getParameter();
                    this.mailFrom = string.substring(1, string.length() - 1);
                    this.reply(250, "OK");
                    continue;
                }
                if (type == SmtpCommand.Type.QUIT) {
                    this.reply(250, "OK");
                    break;
                }
                this.reply(503, "Bad sequence of command (wrong command)");
                continue;
            }
            if (this.recipients == null) {
                if (type != SmtpCommand.Type.RECIPIENT) {
                    this.reply(503, "Bad sequence of command (wrong command)");
                    continue;
                }
                this.recipients = new ArrayList<String>();
                while (type == SmtpCommand.Type.RECIPIENT) {
                    string = ((SmtpCommand)object).getParameter();
                    this.recipients.add(string.substring(1, string.length() - 1));
                    this.reply(250, "OK");
                    object = this.nextCommand();
                    type = ((SmtpCommand)object).getType();
                }
            }
            if (type == SmtpCommand.Type.DATA) {
                if (this.smtpMessageContent != null) {
                    this.reply(503, "Bad sequence of command (wrong command)");
                    continue;
                }
                this.smtpMessageContent = new StringBuilder(256);
                this.reply(354, "Start mail input; end with <CRLF>.<CRLF>");
                string = this.nextLine();
                while (string != null) {
                    if (string.equals(SmtpProtocolConstants.DOT)) {
                        this.smtpMessageContent.delete(this.smtpMessageContent.length() - SmtpProtocolConstants.CRLF.length(), this.smtpMessageContent.length());
                        break;
                    }
                    if (string.startsWith(SmtpProtocolConstants.DOT)) {
                        string = string.substring(1);
                    }
                    this.smtpMessageContent.append(string).append(SmtpProtocolConstants.CRLF);
                    string = this.nextLine();
                }
                this.reply(250, "OK");
                continue;
            }
            if (type == SmtpCommand.Type.QUIT) {
                this.reply(250, "OK");
                break;
            }
            this.reply(503, "Bad sequence of command (wrong command)");
        }
        if (this.smtpMessageContent != null) {
            object = SmtpMessage.create(this.mailFrom, this.recipients, this.smtpMessageContent.toString(), new ArrayList<SmtpExchange>(this.exchanges));
            this.messageReceiver.receiveMessage((SmtpMessage)object);
        }
    }

    private void resetState() {
        this.mailFrom = null;
        this.recipients = null;
        this.smtpMessageContent = null;
    }

    private String nextLine() throws SmtpProtocolException {
        try {
            String string = this.input.readLine();
            if (string == null) {
                throw new SmtpProtocolException("Unexpected end of stream (no more line)");
            }
            this.readData.add(string);
            return string;
        }
        catch (IOException iOException) {
            throw new SmtpProtocolException("I/O exception", iOException);
        }
    }

    private SmtpCommand nextCommand() throws SmtpProtocolException {
        SmtpCommand smtpCommand = SmtpCommand.parse(this.nextLine());
        while (smtpCommand != null) {
            SmtpCommand.Type type = smtpCommand.getType();
            if (type == SmtpCommand.Type.NOOP) {
                this.reply(250, "OK");
            } else if (type == SmtpCommand.Type.EXPAND) {
                this.reply(255, "Not supported");
            } else if (type == SmtpCommand.Type.VERIFY) {
                this.reply(255, "Not supported");
            } else if (type == SmtpCommand.Type.HELP) {
                this.reply(255, "Not supported");
            } else if (type == SmtpCommand.Type.UNKNOWN) {
                this.reply(500, "Unknown command");
            } else if (type == SmtpCommand.Type.RESET) {
                this.resetState();
                this.reply(250, "OK");
            } else {
                return smtpCommand;
            }
            smtpCommand = SmtpCommand.parse(this.nextLine());
        }
        throw new SmtpProtocolException("Unexpected end of exchange (no more command)");
    }

    private void reply(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(n);
        if (string != null) {
            stringBuilder.append(SmtpProtocolConstants.SP);
            stringBuilder.append(string);
        }
        stringBuilder.append(SmtpProtocolConstants.CRLF);
        SmtpExchange smtpExchange = new SmtpExchange(new ArrayList<String>(this.readData), stringBuilder.toString());
        this.exchanges.add(smtpExchange);
        this.readData.clear();
        this.output.print(stringBuilder.toString());
        this.output.flush();
    }

    @FunctionalInterface
    public static interface MessageReceiver {
        public void receiveMessage(SmtpMessage var1);
    }
}

