/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j;

import ch.astorm.smtp4j.core.DefaultSmtpMessageHandler;
import ch.astorm.smtp4j.core.SmtpMessage;
import ch.astorm.smtp4j.core.SmtpMessageHandler;
import ch.astorm.smtp4j.core.SmtpServerListener;
import ch.astorm.smtp4j.protocol.SmtpProtocolException;
import ch.astorm.smtp4j.protocol.SmtpTransactionHandler;
import jakarta.mail.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SmtpServer
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(SmtpServer.class.getName());
    private int port;
    private final SmtpMessageHandler messageHandler;
    private final List<SmtpServerListener> listeners;
    private final ThreadFactory threadFactory;
    private volatile ServerSocket serverSocket;
    private Thread localThread;
    public static int DEFAULT_PORT = 25;

    public SmtpServer(int n) {
        this(n, null, null);
    }

    public SmtpServer(int n, SmtpMessageHandler smtpMessageHandler, ThreadFactory threadFactory) {
        this.port = n;
        this.messageHandler = smtpMessageHandler != null ? smtpMessageHandler : new DefaultSmtpMessageHandler();
        this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
        this.listeners = new ArrayList<SmtpServerListener>(4);
    }

    public Properties getSessionProperties() {
        if (this.port <= 0) {
            throw new IllegalStateException("Dynamic port lookup: server must be started");
        }
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", "localhost");
        properties.setProperty("mail.smtp.port", "" + this.port);
        return properties;
    }

    public Session createSession() {
        return Session.getInstance((Properties)this.getSessionProperties());
    }

    public SmtpMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public SmtpMessageHandler.SmtpMessageReader receivedMessageReader() {
        return this.messageHandler.messageReader();
    }

    public List<SmtpMessage> readReceivedMessages() {
        return this.readReceivedMessages(200L, TimeUnit.MILLISECONDS);
    }

    public List<SmtpMessage> readReceivedMessages(long l, TimeUnit timeUnit) {
        return this.messageHandler.readMessages(l, timeUnit);
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.serverSocket != null;
    }

    public boolean isClosed() {
        return this.serverSocket == null;
    }

    public synchronized void start() throws IOException {
        if (!this.isClosed()) {
            throw new IllegalStateException("Server already started");
        }
        if (this.port <= 0) {
            this.serverSocket = this.createSocketIfPossible(DEFAULT_PORT);
            if (this.serverSocket != null) {
                this.port = DEFAULT_PORT;
            } else {
                for (int i = 1024; this.serverSocket == null && i < 65536; ++i) {
                    this.serverSocket = this.createSocketIfPossible(i);
                    if (this.serverSocket == null) continue;
                    this.port = i;
                }
            }
            if (this.serverSocket == null) {
                throw new IOException("Unable to start SMTP server (no free port found)");
            }
        } else {
            this.serverSocket = new ServerSocket(this.port);
        }
        this.localThread = this.threadFactory.newThread(new SmtpPacketListener());
        this.localThread.start();
        this.notifyStarted();
    }

    private ServerSocket createSocketIfPossible(int n) {
        try {
            return new ServerSocket(n);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void addListener(SmtpServerListener smtpServerListener) {
        this.listeners.add(smtpServerListener);
    }

    public boolean removeListener(SmtpServerListener smtpServerListener) {
        return this.listeners.remove(smtpServerListener);
    }

    public List<SmtpServerListener> getListeners() {
        return this.listeners;
    }

    private void notifyStarted() {
        this.messageHandler.notifyStart(this);
        this.listeners.forEach(smtpServerListener -> smtpServerListener.notifyStart(this));
    }

    private void notifyClosed() {
        this.messageHandler.notifyClose(this);
        this.listeners.forEach(smtpServerListener -> smtpServerListener.notifyClose(this));
    }

    private void notifyMessage(SmtpMessage smtpMessage) {
        this.messageHandler.notifyMessage(this, smtpMessage);
        this.listeners.forEach(smtpServerListener -> smtpServerListener.notifyMessage(this, smtpMessage));
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        ServerSocket serverSocket = this.serverSocket;
        this.serverSocket = null;
        serverSocket.close();
        try {
            this.localThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.localThread = null;
        this.notifyClosed();
    }

    private class SmtpPacketListener
    implements Runnable {
        private SmtpPacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (SmtpServer.this.serverSocket != null) {
                try {
                    Socket socket = SmtpServer.this.serverSocket.accept();
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.ISO_8859_1));
                         PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.ISO_8859_1));){
                        SmtpMessageHandler smtpMessageHandler = SmtpServer.this.messageHandler;
                        synchronized (smtpMessageHandler) {
                            SmtpTransactionHandler.handle(bufferedReader, printWriter, smtpMessage -> SmtpServer.this.notifyMessage(smtpMessage));
                        }
                    }
                    finally {
                        if (socket == null) continue;
                        socket.close();
                    }
                }
                catch (SmtpProtocolException smtpProtocolException) {
                    LOG.log(Level.WARNING, "Protocol Exception", smtpProtocolException);
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINER, "I/O Exception", iOException);
                }
            }
        }
    }
}

