/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j;

import ch.astorm.smtp4j.SmtpServer;
import ch.astorm.smtp4j.core.SmtpMessageHandler;
import ch.astorm.smtp4j.core.SmtpServerListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;

public class SmtpServerBuilder {
    private int port;
    private SmtpMessageHandler handler;
    private List<SmtpServerListener> listeners;
    private ThreadFactory threadFactory;

    public SmtpServerBuilder withPort(int n) {
        this.port = n;
        return this;
    }

    public SmtpServerBuilder withMessageHandler(SmtpMessageHandler smtpMessageHandler) {
        this.handler = smtpMessageHandler;
        return this;
    }

    public SmtpServerBuilder withThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public SmtpServerBuilder withListener(SmtpServerListener smtpServerListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<SmtpServerListener>();
        }
        this.listeners.add(smtpServerListener);
        return this;
    }

    public SmtpServer build() {
        SmtpServer smtpServer = new SmtpServer(this.port, this.handler, this.threadFactory);
        if (this.listeners != null) {
            this.listeners.forEach(smtpServerListener -> smtpServer.addListener((SmtpServerListener)smtpServerListener));
        }
        return smtpServer;
    }

    public SmtpServer start() throws IOException {
        SmtpServer smtpServer = this.build();
        smtpServer.start();
        return smtpServer;
    }
}

