/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j.protocol;

import ch.astorm.smtp4j.protocol.SmtpProtocolConstants;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class SmtpCommand {
    private final Type type;
    private final String parameter;

    public SmtpCommand(Type type, String string) {
        this.type = type;
        this.parameter = string;
    }

    public Type getType() {
        return this.type;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String toString() {
        return this.type + (String)(this.parameter != null ? " " + this.parameter : "");
    }

    public static SmtpCommand parse(String string) {
        String string2;
        String string3;
        if (string == null) {
            return null;
        }
        int n = string.indexOf(SmtpProtocolConstants.COLON);
        if (n >= 0) {
            string3 = string.substring(0, n + 1);
            string2 = string.substring(n + 1).trim();
        } else {
            int n2 = string.indexOf(SmtpProtocolConstants.SP);
            string3 = n2 < 0 ? string : string.substring(0, n2);
            string2 = n2 < 0 ? null : string.substring(n2 + 1).trim();
        }
        for (Type type : Type.values()) {
            if (!type.matches(string3)) continue;
            return new SmtpCommand(type, string2);
        }
        return new SmtpCommand(Type.UNKNOWN, string);
    }

    public static enum Type {
        EHLO("EHLO", "HELO"),
        QUIT("QUIT"),
        MAIL_FROM("MAIL FROM:"),
        RECIPIENT("RCPT TO:"),
        DATA("DATA"),
        EXPAND("EXPN"),
        VERIFY("VRFY"),
        NOOP("NOOP"),
        HELP("HELP"),
        RESET("RSET"),
        UNKNOWN("#UNKN#");

        private final List<String> cmds;

        private Type(String ... stringArray) {
            this.cmds = Arrays.asList(stringArray);
        }

        public boolean matches(String string) {
            return this.cmds.contains(string.toUpperCase(Locale.ROOT));
        }
    }
}

