/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j;

import ch.astorm.smtp4j.SmtpServerOptions;
import ch.astorm.smtp4j.core.DefaultSmtpMessageHandler;
import ch.astorm.smtp4j.core.SmtpMessage;
import ch.astorm.smtp4j.core.SmtpMessageHandler;
import ch.astorm.smtp4j.core.SmtpServerListener;
import ch.astorm.smtp4j.protocol.SmtpProtocolException;
import ch.astorm.smtp4j.protocol.SmtpTransactionHandler;
import jakarta.mail.Authenticator;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SmtpServer
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(SmtpServer.class.getName());
    private int port;
    private final SmtpMessageHandler messageHandler;
    private final ReentrantLock messageHandlerLock;
    private final List<SmtpServerListener> listeners;
    private final ExecutorService executor;
    private volatile SmtpServerOptions serverOptions;
    private volatile ServerSocket serverSocket;
    private Future<?> runningServer;
    public static int DEFAULT_PORT = 25;

    public SmtpServer(int n) {
        this(n, null, null);
    }

    public SmtpServer(int n, SmtpMessageHandler smtpMessageHandler, ExecutorService executorService) {
        this.port = n;
        this.messageHandler = smtpMessageHandler != null ? smtpMessageHandler : new DefaultSmtpMessageHandler();
        this.messageHandlerLock = new ReentrantLock();
        this.executor = executorService != null ? executorService : Executors.newSingleThreadExecutor();
        this.listeners = new ArrayList<SmtpServerListener>(4);
        this.serverOptions = new SmtpServerOptions();
    }

    public SmtpServerOptions getOptions() {
        return this.serverOptions;
    }

    public void setOptions(SmtpServerOptions smtpServerOptions) {
        if (smtpServerOptions == null) {
            throw new IllegalArgumentException("options not defined");
        }
        this.serverOptions = smtpServerOptions;
    }

    public Properties getSessionProperties() {
        if (this.port <= 0) {
            throw new IllegalStateException("Dynamic port lookup: server must be started");
        }
        String string2 = this.serverOptions.protocol.name().toLowerCase();
        Properties properties = new Properties();
        properties.setProperty("mail.transport.protocol", string2);
        properties.setProperty("mail.transport.protocol.rfc822", string2);
        properties.setProperty("mail." + string2 + ".host", "localhost");
        properties.setProperty("mail." + string2 + ".port", "" + this.port);
        if (this.serverOptions.startTLS) {
            properties.put("mail." + string2 + ".starttls.enable", "true");
            properties.put("mail." + string2 + ".starttls.required", "true");
        }
        if (this.serverOptions.startTLS || this.serverOptions.protocol == SmtpServerOptions.Protocol.SMTPS) {
            properties.put("mail." + string2 + ".ssl.checkserveridentity", "false");
            properties.put("mail." + string2 + ".ssl.trust", "*");
        }
        if (this.serverOptions.authenticators != null && !this.serverOptions.authenticators.isEmpty()) {
            properties.put("mail." + string2 + ".auth", "true");
            if (this.serverOptions.authenticators.stream().map(smtpAuthenticatorHandler -> smtpAuthenticatorHandler.getName()).anyMatch(string -> string.equals("CRAM-MD5"))) {
                properties.put("mail." + string2 + ".sasl.enable", "true");
            }
        }
        return properties;
    }

    public Session createSession() {
        return Session.getInstance((Properties)this.getSessionProperties());
    }

    public Session createAuthenticatedSession(final String string, final String string2) {
        return Session.getInstance((Properties)this.getSessionProperties(), (Authenticator)new Authenticator(this){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(string, string2);
            }
        });
    }

    public SmtpMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public SmtpMessageHandler.SmtpMessageReader receivedMessageReader() {
        return this.messageHandler.messageReader();
    }

    public List<SmtpMessage> readReceivedMessages() {
        return this.readReceivedMessages(200L, TimeUnit.MILLISECONDS);
    }

    public List<SmtpMessage> readReceivedMessages(long l, TimeUnit timeUnit) {
        return this.messageHandler.readMessages(l, timeUnit);
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.serverSocket != null;
    }

    public boolean isClosed() {
        return this.serverSocket == null;
    }

    public void start() throws IOException {
        if (!this.isClosed()) {
            throw new IllegalStateException("Server already started");
        }
        if (this.port <= 0) {
            this.serverSocket = this.createSocketIfPossible(DEFAULT_PORT);
            if (this.serverSocket != null) {
                this.port = DEFAULT_PORT;
            } else {
                for (int i = 1024; this.serverSocket == null && i < 65536; ++i) {
                    this.serverSocket = this.createSocketIfPossible(i);
                    if (this.serverSocket == null) continue;
                    this.port = i;
                }
            }
            if (this.serverSocket == null) {
                throw new IOException("Unable to start SMTP server (no free port found)");
            }
        } else {
            this.serverSocket = new ServerSocket(this.port);
        }
        this.runningServer = this.executor.submit(new SmtpPacketListener());
        this.messageHandlerLock.lock();
        try {
            this.notifyStarted();
        }
        finally {
            this.messageHandlerLock.unlock();
        }
    }

    private ServerSocket createSocketIfPossible(int n) {
        try {
            return new ServerSocket(n);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void addListener(SmtpServerListener smtpServerListener) {
        this.listeners.add(smtpServerListener);
    }

    public boolean removeListener(SmtpServerListener smtpServerListener) {
        return this.listeners.remove(smtpServerListener);
    }

    public List<SmtpServerListener> getListeners() {
        return this.listeners;
    }

    private void notifyStarted() {
        this.messageHandler.notifyStart(this);
        this.listeners.forEach(smtpServerListener -> smtpServerListener.notifyStart(this));
    }

    private void notifyClosed() {
        this.messageHandler.notifyClose(this);
        this.listeners.forEach(smtpServerListener -> smtpServerListener.notifyClose(this));
    }

    private void notifyMessage(SmtpMessage smtpMessage) {
        this.messageHandler.notifyMessage(this, smtpMessage);
        this.listeners.forEach(smtpServerListener -> smtpServerListener.notifyMessage(this, smtpMessage));
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        ServerSocket serverSocket = this.serverSocket;
        this.serverSocket = null;
        serverSocket.close();
        try {
            this.runningServer.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        this.runningServer = null;
        this.messageHandlerLock.lock();
        try {
            this.notifyClosed();
        }
        finally {
            this.messageHandlerLock.unlock();
        }
    }

    private class SmtpPacketListener
    implements Runnable {
        private SmtpPacketListener() {
        }

        @Override
        public void run() {
            while (SmtpServer.this.serverSocket != null) {
                try {
                    Socket socket = SmtpServer.this.serverSocket.accept();
                    try {
                        SmtpServer.this.messageHandlerLock.lock();
                        try {
                            SmtpTransactionHandler.handle(SmtpServer.this, socket, smtpMessage -> SmtpServer.this.notifyMessage(smtpMessage));
                        }
                        finally {
                            SmtpServer.this.messageHandlerLock.unlock();
                        }
                    }
                    finally {
                        if (socket == null) continue;
                        socket.close();
                    }
                }
                catch (SmtpProtocolException smtpProtocolException) {
                    LOG.log(Level.WARNING, "Protocol Exception", smtpProtocolException);
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINER, "I/O Exception", iOException);
                }
            }
        }
    }
}

