/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j;

import ch.astorm.smtp4j.SmtpServer;
import ch.astorm.smtp4j.SmtpServerOptions;
import ch.astorm.smtp4j.auth.SmtpAuthenticatorHandler;
import ch.astorm.smtp4j.core.SmtpMessageHandler;
import ch.astorm.smtp4j.core.SmtpServerListener;
import ch.astorm.smtp4j.secure.SSLContextProvider;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public class SmtpServerBuilder {
    private int port;
    private SmtpMessageHandler handler;
    private SmtpServerOptions options;
    private List<SmtpServerListener> listeners;
    private ExecutorService executor;

    public SmtpServerBuilder withPort(int n) {
        this.port = n;
        return this;
    }

    public SmtpServerBuilder withOptions(SmtpServerOptions smtpServerOptions) {
        this.options = smtpServerOptions;
        return this;
    }

    public SmtpServerBuilder withStartTLSSupport(boolean bl) {
        if (this.options == null) {
            this.options = new SmtpServerOptions();
        }
        this.options.startTLS = bl;
        return this;
    }

    public SmtpServerBuilder withStartTLSRequired(boolean bl) {
        if (this.options == null) {
            this.options = new SmtpServerOptions();
        }
        this.options.requireTLS = bl;
        return this;
    }

    public SmtpServerBuilder withProtocol(SmtpServerOptions.Protocol protocol) {
        if (this.options == null) {
            this.options = new SmtpServerOptions();
        }
        this.options.protocol = protocol;
        return this;
    }

    public SmtpServerBuilder withSSLContextProvider(SSLContextProvider sSLContextProvider) {
        if (this.options == null) {
            this.options = new SmtpServerOptions();
        }
        this.options.sslContextProvider = sSLContextProvider;
        return this;
    }

    public SmtpServerBuilder withMaxMessageSize(int n) {
        if (this.options == null) {
            this.options = new SmtpServerOptions();
        }
        this.options.maxMessageSize = n;
        return this;
    }

    public SmtpServerBuilder withDebugStream(PrintStream printStream) {
        if (this.options == null) {
            this.options = new SmtpServerOptions();
        }
        this.options.debugStream = printStream;
        return this;
    }

    public SmtpServerBuilder withConnectionString(String string) {
        if (this.options == null) {
            this.options = new SmtpServerOptions();
        }
        this.options.connectionString = string;
        return this;
    }

    public SmtpServerBuilder withEHLOResponseFunction(Function<String, String> function) {
        if (this.options == null) {
            this.options = new SmtpServerOptions();
        }
        this.options.ehloResponseFunction = function;
        return this;
    }

    public SmtpServerBuilder withAuthenticator(SmtpAuthenticatorHandler smtpAuthenticatorHandler) {
        if (this.options == null) {
            this.options = new SmtpServerOptions();
        }
        this.options.authenticators.add(smtpAuthenticatorHandler);
        return this;
    }

    public SmtpServerBuilder withUser(String string, String string2) {
        if (this.options == null) {
            this.options = new SmtpServerOptions();
        }
        this.options.usersRepository.addUser(string, string2);
        return this;
    }

    public SmtpServerBuilder withMessageHandler(SmtpMessageHandler smtpMessageHandler) {
        this.handler = smtpMessageHandler;
        return this;
    }

    public SmtpServerBuilder withExecutorService(ExecutorService executorService) {
        this.executor = executorService;
        return this;
    }

    public SmtpServerBuilder withListener(SmtpServerListener smtpServerListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<SmtpServerListener>();
        }
        this.listeners.add(smtpServerListener);
        return this;
    }

    public SmtpServer build() {
        SmtpServer smtpServer = new SmtpServer(this.port, this.handler, this.executor);
        if (this.options != null) {
            smtpServer.setOptions(this.options);
        }
        if (this.listeners != null) {
            this.listeners.forEach(smtpServerListener -> smtpServer.addListener((SmtpServerListener)smtpServerListener));
        }
        return smtpServer;
    }

    public SmtpServer start() throws IOException {
        SmtpServer smtpServer = this.build();
        smtpServer.start();
        return smtpServer;
    }
}

