/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j.protocol;

import ch.astorm.smtp4j.protocol.SmtpMessageSizeExceededException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class SmtpBufferedInputStream
extends BufferedInputStream {
    private int sizeLimit = -1;
    private int readByteCounter = 0;
    private boolean readByteUpdate = true;

    public SmtpBufferedInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public void setByteCounterEnabled(boolean bl) {
        this.readByteUpdate = bl;
    }

    public void setSizeLimit(int n) {
        this.sizeLimit = n;
    }

    public byte[] readLine() throws IOException, SmtpMessageSizeExceededException {
        byte[] byArray;
        byte[] byArray2 = null;
        int n = 0;
        int n2 = super.read();
        while (n2 >= 0) {
            if (byArray2 == null || n >= byArray2.length) {
                if (byArray2 != null) {
                    byArray = new byte[byArray2.length * 2];
                    System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                    byArray2 = byArray;
                } else {
                    byArray2 = new byte[1024];
                }
            }
            byArray2[n] = (byte)n2;
            ++n;
            if (this.readByteUpdate) {
                ++this.readByteCounter;
                if (this.sizeLimit > 0 && this.sizeLimit < this.readByteCounter) {
                    throw new SmtpMessageSizeExceededException();
                }
            }
            if (n > 1 && byArray2[n - 2] == 13 && byArray2[n - 1] == 10) {
                if ((n -= 2) != 0) break;
                return new byte[0];
            }
            n2 = super.read();
        }
        if (n <= 0) {
            return null;
        }
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }
}

