/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j.secure;

import ch.astorm.smtp4j.secure.SSLContextProvider;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class DefaultSSLContextProvider
implements SSLContextProvider {
    private final KeyManagerFactory keyManagerFactory;

    public DefaultSSLContextProvider(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = keyManagerFactory;
    }

    public static DefaultSSLContextProvider create(KeyStore keyStore, char[] cArray) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, cArray);
        return new DefaultSSLContextProvider(keyManagerFactory);
    }

    public static DefaultSSLContextProvider selfSigned() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, IOException, CertificateException {
        char[] cArray = "smtp4j".toCharArray();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        try (InputStream inputStream = DefaultSSLContextProvider.class.getResourceAsStream("keystore.jks");){
            keyStore.load(inputStream, cArray);
        }
        return DefaultSSLContextProvider.create(keyStore, cArray);
    }

    @Override
    public SSLContext getSSLContext() throws Exception {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(this.keyManagerFactory.getKeyManagers(), null, null);
        return sSLContext;
    }
}

