/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j.auth;

import ch.astorm.smtp4j.SmtpServerOptions;
import ch.astorm.smtp4j.auth.SmtpAuthenticatorHandler;
import ch.astorm.smtp4j.auth.SmtpExchangeHandler;
import ch.astorm.smtp4j.protocol.SmtpCommand;
import ch.astorm.smtp4j.protocol.SmtpProtocolException;
import ch.astorm.smtp4j.store.UserAuthenticator;
import jakarta.mail.PasswordAuthentication;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;

public class PlainAuthenticationHandler
implements SmtpAuthenticatorHandler {
    public static PlainAuthenticationHandler INSTANCE = new PlainAuthenticationHandler();

    private PlainAuthenticationHandler() {
    }

    @Override
    public String getName() {
        return "PLAIN";
    }

    @Override
    public boolean authenticate(SmtpCommand smtpCommand, SmtpExchangeHandler smtpExchangeHandler, SmtpServerOptions smtpServerOptions) throws SmtpProtocolException {
        String string;
        String string2 = smtpCommand.getParameter();
        int n = string2.indexOf(32);
        if (n < 0) {
            smtpExchangeHandler.reply(334);
            string = smtpExchangeHandler.nextLine();
        } else {
            string = string2.substring(n + 1);
        }
        byte[] byArray = Base64.getDecoder().decode(string);
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by != 0) continue;
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            if (n3 >= 0) continue;
            n3 = i;
            break;
        }
        if (n2 < 0 || n3 < 0) {
            throw new SmtpProtocolException("Invalid credentials format");
        }
        String string3 = new String(Arrays.copyOfRange(byArray, 0, n2), StandardCharsets.UTF_8);
        String string4 = new String(Arrays.copyOfRange(byArray, n2 + 1, n3), StandardCharsets.UTF_8);
        String string5 = new String(Arrays.copyOfRange(byArray, n3 + 1, byArray.length), StandardCharsets.UTF_8);
        UserAuthenticator userAuthenticator = smtpServerOptions.usersRepository.getAuthenticator();
        try {
            userAuthenticator.checkCredentials(new PasswordAuthentication(string4, string5));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

