/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j.auth;

import ch.astorm.smtp4j.SmtpServerOptions;
import ch.astorm.smtp4j.auth.SmtpAuthenticatorHandler;
import ch.astorm.smtp4j.auth.SmtpExchangeHandler;
import ch.astorm.smtp4j.protocol.SmtpCommand;
import ch.astorm.smtp4j.protocol.SmtpProtocolException;
import ch.astorm.smtp4j.store.UserAuthenticator;
import jakarta.mail.PasswordAuthentication;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Properties;

public class XOAuth2AuthenticationHandler
implements SmtpAuthenticatorHandler {
    private static final byte CONTROL_A = 1;
    public static XOAuth2AuthenticationHandler INSTANCE = new XOAuth2AuthenticationHandler();

    @Override
    public String getName() {
        return "XOAUTH2";
    }

    @Override
    public boolean authenticate(SmtpCommand smtpCommand, SmtpExchangeHandler smtpExchangeHandler, SmtpServerOptions smtpServerOptions) throws SmtpProtocolException {
        String string = smtpCommand.getParameter();
        int n = string.indexOf(32);
        if (n < 0) {
            throw new SmtpProtocolException("Invalid credentials format");
        }
        String string2 = string.substring(n + 1);
        byte[] byArray = Base64.getDecoder().decode(string2);
        String string3 = new String(byArray, StandardCharsets.UTF_8);
        int n2 = string3.indexOf(1);
        if (n2 < 0) {
            throw new SmtpProtocolException("Invalid credential format");
        }
        String string4 = string3.substring(0, n2);
        if (!string4.toLowerCase().startsWith("user=")) {
            throw new SmtpProtocolException("Invalid user prop in credentials");
        }
        String string5 = string3.substring(n2 + 1);
        if (!string5.toLowerCase().startsWith("auth=bearer ")) {
            throw new SmtpProtocolException("Invalid auth prop in credentials");
        }
        String string6 = string4.substring("user=".length()).trim();
        String string7 = string5.substring("auth=bearer ".length()).trim();
        UserAuthenticator userAuthenticator = smtpServerOptions.usersRepository.getAuthenticator();
        try {
            userAuthenticator.checkCredentials(new PasswordAuthentication(string6, string7));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void setSessionProperties(Properties properties, SmtpServerOptions smtpServerOptions) {
        String string = smtpServerOptions.protocol.name().toLowerCase();
        properties.put("mail." + string + ".sasl.enable", "true");
        properties.put("mail." + string + ".sasl.mechanisms", "XOAUTH2");
    }
}

