/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j;

import ch.astorm.smtp4j.SmtpServerOptions;
import ch.astorm.smtp4j.connection.ConnectionListener;
import ch.astorm.smtp4j.core.DefaultSmtpMessageHandler;
import ch.astorm.smtp4j.core.SmtpMessage;
import ch.astorm.smtp4j.core.SmtpMessageHandler;
import ch.astorm.smtp4j.core.SmtpServerListener;
import ch.astorm.smtp4j.protocol.DefaultSmtpTransactionHandler;
import ch.astorm.smtp4j.protocol.SmtpTransactionHandler;
import ch.astorm.smtp4j.protocol.SmtpTransactionHandlerFactory;
import jakarta.mail.Authenticator;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SmtpServer
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(SmtpServer.class.getName());
    private int port;
    private final SmtpMessageHandler messageHandler;
    private final ReentrantLock messageHandlerLock;
    private final List<SmtpServerListener> serverListeners;
    private final Supplier<ExecutorService> executorSupplier;
    private final SmtpTransactionHandlerFactory handlerFactory;
    private final ConnectionListener connectionListener;
    private volatile SmtpServerOptions options;
    private volatile ServerSocket serverSocket;
    private Future<?> runningServer;
    private ExecutorService executor;
    public static int DEFAULT_PORT = 25;

    public SmtpServer(int n) {
        this(n, null, null, null, null);
    }

    public SmtpServer(int n, SmtpMessageHandler smtpMessageHandler, Supplier<ExecutorService> supplier, SmtpTransactionHandlerFactory smtpTransactionHandlerFactory, ConnectionListener connectionListener) {
        this.port = n;
        this.messageHandler = smtpMessageHandler != null ? smtpMessageHandler : new DefaultSmtpMessageHandler();
        this.messageHandlerLock = new ReentrantLock();
        this.executorSupplier = supplier != null ? supplier : () -> Executors.newWorkStealingPool();
        this.handlerFactory = smtpTransactionHandlerFactory != null ? smtpTransactionHandlerFactory : (smtpServer, messageReceiver) -> new DefaultSmtpTransactionHandler(smtpServer, messageReceiver);
        this.connectionListener = connectionListener;
        this.serverListeners = new ArrayList<SmtpServerListener>(4);
        this.options = new SmtpServerOptions();
    }

    public SmtpServerOptions getOptions() {
        return this.options;
    }

    public void setOptions(SmtpServerOptions smtpServerOptions) {
        if (smtpServerOptions == null) {
            throw new IllegalArgumentException("options not defined");
        }
        this.options = smtpServerOptions;
    }

    public Properties getSessionProperties() {
        if (this.port <= 0) {
            throw new IllegalStateException("Dynamic port lookup: server must be started");
        }
        String string = this.options.protocol.name().toLowerCase();
        Properties properties = new Properties();
        properties.setProperty("mail.transport.protocol", string);
        properties.setProperty("mail.transport.protocol.rfc822", string);
        properties.setProperty("mail." + string + ".host", "localhost");
        properties.setProperty("mail." + string + ".port", "" + this.port);
        if (this.options.startTLS) {
            properties.put("mail." + string + ".starttls.enable", "true");
            properties.put("mail." + string + ".starttls.required", "true");
        }
        if (this.options.startTLS || this.options.protocol == SmtpServerOptions.Protocol.SMTPS) {
            properties.put("mail." + string + ".ssl.checkserveridentity", "false");
            properties.put("mail." + string + ".ssl.trust", "*");
        }
        if (this.options.authenticators != null && !this.options.authenticators.isEmpty()) {
            properties.put("mail." + string + ".auth", "true");
            this.options.authenticators.stream().forEach(smtpAuthenticatorHandler -> smtpAuthenticatorHandler.setSessionProperties(properties, this.options));
        }
        return properties;
    }

    public Session createSession() {
        return Session.getInstance((Properties)this.getSessionProperties());
    }

    public Session createAuthenticatedSession(final String string, final String string2) {
        return Session.getInstance((Properties)this.getSessionProperties(), (Authenticator)new Authenticator(this){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(string, string2);
            }
        });
    }

    public SmtpMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public SmtpMessageHandler.SmtpMessageReader receivedMessageReader() {
        return this.messageHandler.messageReader();
    }

    public List<SmtpMessage> readReceivedMessages() {
        return this.readReceivedMessages(200L, TimeUnit.MILLISECONDS);
    }

    public List<SmtpMessage> readReceivedMessages(long l, TimeUnit timeUnit) {
        return this.messageHandler.readMessages(l, timeUnit);
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.serverSocket != null;
    }

    public boolean isClosed() {
        return this.serverSocket == null;
    }

    public void start() throws IOException {
        if (!this.isClosed()) {
            throw new IllegalStateException("Server already started");
        }
        if (this.port <= 0) {
            this.serverSocket = this.createSocketIfPossible(DEFAULT_PORT);
            if (this.serverSocket != null) {
                this.port = DEFAULT_PORT;
            } else {
                for (int i = 1024; this.serverSocket == null && i < 65536; ++i) {
                    this.serverSocket = this.createSocketIfPossible(i);
                    if (this.serverSocket == null) continue;
                    this.port = i;
                }
            }
            if (this.serverSocket == null) {
                throw new IOException("Unable to start SMTP server (no free port found)");
            }
        } else {
            this.serverSocket = new ServerSocket(this.port);
        }
        this.executor = this.executorSupplier.get();
        this.runningServer = this.executor.submit(new SmtpPacketListener());
        this.messageHandlerLock.lock();
        try {
            this.notifyStarted();
        }
        finally {
            this.messageHandlerLock.unlock();
        }
    }

    private ServerSocket createSocketIfPossible(int n) {
        try {
            return new ServerSocket(n);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void addListener(SmtpServerListener smtpServerListener) {
        this.serverListeners.add(smtpServerListener);
    }

    public boolean removeListener(SmtpServerListener smtpServerListener) {
        return this.serverListeners.remove(smtpServerListener);
    }

    public List<SmtpServerListener> getListeners() {
        return this.serverListeners;
    }

    private void notifyStarted() {
        this.messageHandler.notifyStart(this);
        this.serverListeners.forEach(smtpServerListener -> smtpServerListener.notifyStart(this));
    }

    private void notifyClosed() {
        this.messageHandler.notifyClose(this);
        this.serverListeners.forEach(smtpServerListener -> smtpServerListener.notifyClose(this));
    }

    private void notifyMessage(SmtpMessage smtpMessage) {
        this.messageHandler.notifyMessage(this, smtpMessage);
        this.serverListeners.forEach(smtpServerListener -> smtpServerListener.notifyMessage(this, smtpMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AutoCloseable autoCloseable;
        if (this.isClosed()) {
            return;
        }
        try {
            autoCloseable = this.serverSocket;
            try {
                this.serverSocket = null;
            }
            finally {
                if (autoCloseable != null) {
                    ((ServerSocket)autoCloseable).close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.runningServer.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.runningServer = null;
        try {
            autoCloseable = this.executor;
            try {
                this.executor = null;
            }
            finally {
                if (autoCloseable != null) {
                    autoCloseable.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.messageHandlerLock.lock();
        try {
            this.notifyClosed();
        }
        finally {
            this.messageHandlerLock.unlock();
        }
    }

    private class SmtpPacketListener
    implements Runnable {
        private SmtpPacketListener() {
        }

        @Override
        public void run() {
            DefaultSmtpTransactionHandler.MessageReceiver messageReceiver = smtpMessage -> {
                SmtpServer.this.messageHandlerLock.lock();
                try {
                    SmtpServer.this.notifyMessage(smtpMessage);
                }
                finally {
                    SmtpServer.this.messageHandlerLock.unlock();
                }
            };
            while (SmtpServer.this.serverSocket != null) {
                try {
                    Socket socket = SmtpServer.this.serverSocket.accept();
                    socket.setSoTimeout(SmtpServer.this.options.socketTimeout);
                    if (SmtpServer.this.connectionListener != null) {
                        try {
                            SmtpServer.this.connectionListener.connected(socket.getInetAddress());
                        }
                        catch (Throwable throwable) {
                            socket.close();
                            continue;
                        }
                    }
                    SmtpServer.this.executor.submit(() -> {
                        try (Socket socket2 = socket;
                             SmtpTransactionHandler smtpTransactionHandler = SmtpServer.this.handlerFactory.create(SmtpServer.this, messageReceiver);){
                            smtpTransactionHandler.execute(socket);
                        }
                        catch (Throwable throwable) {
                            LOG.log(Level.WARNING, "SMTP transaction ended unexpectedly", throwable);
                        }
                        return null;
                    });
                }
                catch (Throwable throwable) {
                    LOG.log(Level.FINER, "Exception caught", throwable);
                }
            }
        }
    }
}

