/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.smtp4j.protocol;

import ch.astorm.smtp4j.SmtpServer;
import ch.astorm.smtp4j.SmtpServerOptions;
import ch.astorm.smtp4j.auth.SmtpAuthenticatorHandler;
import ch.astorm.smtp4j.auth.SmtpExchangeHandler;
import ch.astorm.smtp4j.core.SmtpMessage;
import ch.astorm.smtp4j.protocol.SmtpBufferedInputStream;
import ch.astorm.smtp4j.protocol.SmtpCommand;
import ch.astorm.smtp4j.protocol.SmtpExchange;
import ch.astorm.smtp4j.protocol.SmtpMessageSizeExceededException;
import ch.astorm.smtp4j.protocol.SmtpProtocolConstants;
import ch.astorm.smtp4j.protocol.SmtpProtocolException;
import ch.astorm.smtp4j.protocol.SmtpTransactionHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class DefaultSmtpTransactionHandler
implements AutoCloseable,
SmtpTransactionHandler {
    private final SmtpServerOptions options;
    private final MessageReceiver messageReceiver;
    private boolean secureChannel;
    private Socket socket;
    private InputStream socketInputStream;
    private OutputStream socketOutputStream;
    private SmtpBufferedInputStream input;
    private PrintWriter output;
    private String mailFrom;
    private List<String> recipients;
    private ByteArrayOutputStream smtpMessageContent;
    private final List<String> readData = new ArrayList<String>(64);
    private final List<SmtpExchange> exchanges = new ArrayList<SmtpExchange>(32);
    private final List<SmtpCommand> stackedCommands = new ArrayList<SmtpCommand>();

    public DefaultSmtpTransactionHandler(SmtpServer smtpServer, MessageReceiver messageReceiver) {
        this.options = smtpServer.getOptions();
        this.messageReceiver = messageReceiver;
    }

    private void initSocket(Socket socket, boolean bl) throws IOException {
        this.secureChannel = bl;
        this.socket = socket;
        this.socketInputStream = socket.getInputStream();
        this.socketOutputStream = socket.getOutputStream();
        this.input = new SmtpBufferedInputStream(this.socketInputStream);
        this.output = new PrintWriter(new OutputStreamWriter(this.socketOutputStream, StandardCharsets.US_ASCII));
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        this.output.close();
        this.socket.close();
    }

    @Override
    public void execute(Socket socket) throws IOException, SmtpProtocolException {
        this.initSocket(socket, false);
        try {
            this.executeInternal();
        }
        catch (SmtpMessageSizeExceededException smtpMessageSizeExceededException) {
            this.reply(552, "Message size exceeded");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeInternal() throws SmtpProtocolException {
        String string3;
        if (!this.secureChannel) {
            if (this.options.protocol == SmtpServerOptions.Protocol.SMTPS) {
                try {
                    this.upgradeToTLSSocket();
                }
                catch (Exception exception) {
                    throw new SmtpProtocolException("TLS Upgrade failed (SMTPS)", exception);
                }
                this.reply(220, this.options.connectionString);
                this.executeInternal();
                return;
            }
            this.reply(220, this.options.connectionString);
        }
        boolean bl = this.options.authenticators != null && !this.options.authenticators.isEmpty();
        boolean bl2 = this.options.startTLS && !this.secureChannel;
        SmtpCommand smtpCommand = SmtpCommand.parse(this.nextLine());
        if (smtpCommand == null) {
            this.reply(503, "Bad sequence of command (no more token)");
            return;
        }
        if (smtpCommand.getType() != SmtpCommand.Type.EHLO) {
            this.reply(503, "Bad sequence of command (wrong command)");
            return;
        }
        Object object = smtpCommand.getParameter();
        Object object2 = this.options.ehloResponseFunction.apply((String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object2);
        arrayList.add("SMTPUTF8");
        arrayList.add("8BITMIME");
        if (bl2) {
            arrayList.add("STARTTLS");
            if (this.options.requireTLS) {
                arrayList.add("REQUIRETLS");
            }
        }
        if (bl) {
            string3 = this.options.authenticators.stream().map(smtpAuthenticatorHandler -> smtpAuthenticatorHandler.getName()).reduce((string, string2) -> string + " " + string2).get();
            arrayList.add("AUTH " + string3);
        }
        if (this.options.maxMessageSize > 0) {
            arrayList.add("SIZE " + this.options.maxMessageSize);
            this.input.setSizeLimit(this.options.maxMessageSize);
        }
        this.reply(250, arrayList);
        if (bl2) {
            object = this.nextCommand();
            if (((SmtpCommand)object).getType() == SmtpCommand.Type.STARTTLS) {
                object2 = this.output;
                try {
                    this.upgradeToTLSSocket();
                }
                catch (Exception exception) {
                    this.reply(554, "TLS Upgrade failed");
                    throw new SmtpProtocolException("TLS Upgrade failed", exception);
                }
                this.reply((PrintWriter)object2, 220, "Go ahead", SmtpProtocolConstants.SP_FINAL);
                this.executeInternal();
                return;
            }
            if (this.options.requireTLS) {
                this.reply(523, "STARTTLS is mandatory");
                return;
            }
            this.stackedCommands.add((SmtpCommand)object);
        }
        if (bl) {
            object = this.nextCommand();
            if (((SmtpCommand)object).getType() != SmtpCommand.Type.AUTH) {
                this.reply(530, "Authentication needed");
                return;
            }
            int n = ((String)(object2 = ((SmtpCommand)object).getParameter())).indexOf(32);
            string3 = ((String)object2).substring(0, n < 0 ? ((String)object2).length() : n);
            SmtpAuthenticatorHandler smtpAuthenticatorHandler2 = this.options.authenticators.stream().filter(smtpAuthenticatorHandler -> smtpAuthenticatorHandler.getName().equalsIgnoreCase(string3)).findFirst().orElse(null);
            if (smtpAuthenticatorHandler2 == null) {
                this.reply(504, "Authentication scheme " + string3 + " not supported");
                return;
            }
            try {
                boolean bl3;
                boolean bl4 = bl3 = this.options.usersRepository != null ? smtpAuthenticatorHandler2.authenticate((SmtpCommand)object, new InternalExchangeHandler(this), this.options) : false;
                if (!bl3) {
                    this.reply(535, "Authentication failed");
                    return;
                }
                this.reply(235, "Credentials accepted");
            }
            catch (Exception exception) {
                this.reply(535, exception.getMessage());
                if (exception instanceof SmtpProtocolException) {
                    throw (SmtpProtocolException)exception;
                }
                throw new SmtpProtocolException("Unable to process authentication", exception);
            }
        }
        this.readTransaction();
    }

    private void upgradeToTLSSocket() throws Exception {
        if (this.options.sslContextProvider == null) {
            throw new IllegalStateException("No SSLContextProvider defined");
        }
        SSLContext sSLContext = this.options.sslContextProvider.getSSLContext();
        if (sSLContext == null) {
            throw new IllegalStateException("SSLContext is null");
        }
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), true);
        sSLSocket.setUseClientMode(false);
        this.initSocket(sSLSocket, true);
    }

    private void readTransaction() throws SmtpProtocolException {
        while (true) {
            String string;
            SmtpCommand smtpCommand = this.nextCommand();
            SmtpCommand.Type type = smtpCommand.getType();
            if (this.mailFrom == null) {
                if (type == SmtpCommand.Type.MAIL_FROM) {
                    string = smtpCommand.getParameter();
                    this.mailFrom = string.substring(1, string.length() - 1);
                    this.reply(250, "OK");
                    continue;
                }
                if (type == SmtpCommand.Type.QUIT) {
                    this.reply(221, "goodbye");
                    break;
                }
                this.reply(503, "Bad sequence of command (wrong command)");
                continue;
            }
            if (this.recipients == null) {
                if (type == SmtpCommand.Type.QUIT) {
                    this.reply(221, "goodbye");
                    break;
                }
                if (type != SmtpCommand.Type.RECIPIENT) {
                    this.reply(503, "Bad sequence of command (wrong command)");
                    continue;
                }
                this.recipients = new ArrayList<String>();
                while (type == SmtpCommand.Type.RECIPIENT) {
                    string = smtpCommand.getParameter();
                    int n = string.indexOf(62);
                    this.recipients.add(string.substring(1, n));
                    this.reply(250, "OK");
                    smtpCommand = this.nextCommand();
                    type = smtpCommand.getType();
                }
            }
            if (type == SmtpCommand.Type.DATA) {
                if (this.smtpMessageContent != null) {
                    this.reply(503, "Bad sequence of command (wrong command)");
                    continue;
                }
                this.smtpMessageContent = new ByteArrayOutputStream(256);
                this.reply(354, "Start mail input; end with <CRLF>.<CRLF>");
                this.input.setByteCounterEnabled(true);
                boolean bl = false;
                byte[] byArray = this.nextLineRaw();
                while (byArray != null) {
                    byte[] byArray2;
                    if (byArray.length == 1 && byArray[0] == SmtpProtocolConstants.DOT) {
                        byArray2 = this.smtpMessageContent.toByteArray();
                        byte[] byArray3 = new byte[byArray2.length - SmtpProtocolConstants.CRLF.length()];
                        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length - SmtpProtocolConstants.CRLF.length());
                        SmtpMessage smtpMessage = SmtpMessage.create(this.mailFrom, this.recipients, byArray3, new ArrayList<SmtpExchange>(this.exchanges));
                        try {
                            this.messageReceiver.receiveMessage(smtpMessage);
                            this.resetState();
                        }
                        catch (Exception exception) {
                            this.reply(554, exception.getMessage());
                            bl = true;
                        }
                        break;
                    }
                    if (byArray.length > 0 && byArray[0] == SmtpProtocolConstants.DOT) {
                        byArray2 = new byte[byArray.length - 1];
                        System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
                        byArray = byArray2;
                    }
                    this.smtpMessageContent.writeBytes(byArray);
                    this.smtpMessageContent.writeBytes(SmtpProtocolConstants.CRLF.getBytes(StandardCharsets.US_ASCII));
                    byArray = this.nextLineRaw();
                }
                this.input.setByteCounterEnabled(false);
                if (bl) continue;
                this.reply(250, "OK");
                continue;
            }
            if (type == SmtpCommand.Type.QUIT) {
                this.reply(221, "goodbye");
                break;
            }
            this.reply(503, "Bad sequence of command (wrong command)");
        }
    }

    private void resetState() {
        this.mailFrom = null;
        this.recipients = null;
        this.smtpMessageContent = null;
    }

    private byte[] nextLineRaw() throws SmtpProtocolException {
        try {
            byte[] byArray = this.input.readLine();
            if (byArray == null) {
                throw new SmtpProtocolException("Unexpected end of stream (no more line)");
            }
            String string = new String(byArray, StandardCharsets.US_ASCII);
            this.readData.add(string);
            if (this.options.debugStream != null) {
                this.options.debugStream.println("> " + string);
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new SmtpProtocolException("I/O exception", iOException);
        }
    }

    private String nextLine() throws SmtpProtocolException {
        return new String(this.nextLineRaw(), StandardCharsets.US_ASCII);
    }

    private SmtpCommand nextCommand() throws SmtpProtocolException {
        SmtpCommand smtpCommand;
        SmtpCommand smtpCommand2 = smtpCommand = this.stackedCommands.isEmpty() ? SmtpCommand.parse(this.nextLine()) : this.stackedCommands.remove(0);
        while (smtpCommand != null) {
            SmtpCommand.Type type = smtpCommand.getType();
            if (type == SmtpCommand.Type.NOOP) {
                this.reply(250, "OK");
            } else if (type == SmtpCommand.Type.EXPAND) {
                this.reply(255, "Not supported");
            } else if (type == SmtpCommand.Type.VERIFY) {
                this.reply(255, "Not supported");
            } else if (type == SmtpCommand.Type.HELP) {
                this.reply(255, "Not supported");
            } else if (type == SmtpCommand.Type.UNKNOWN) {
                this.reply(500, "Unknown command");
            } else if (type == SmtpCommand.Type.RESET) {
                this.resetState();
                this.reply(250, "OK");
            } else {
                return smtpCommand;
            }
            smtpCommand = SmtpCommand.parse(this.nextLine());
        }
        throw new SmtpProtocolException("Unexpected end of exchange (no more command)");
    }

    private void reply(int n, String string) {
        this.reply(n, string, SmtpProtocolConstants.SP_FINAL);
    }

    private void reply(int n, List<String> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            this.reply(n, list.get(i), SmtpProtocolConstants.SP_CONTINUE);
        }
        this.reply(n, list.get(list.size() - 1), SmtpProtocolConstants.SP_FINAL);
    }

    private void reply(int n, String string, String string2) {
        this.reply(this.output, n, string, string2);
    }

    private void reply(PrintWriter printWriter, int n, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(n);
        if (string != null && !string.trim().isEmpty()) {
            stringBuilder.append(string2);
            stringBuilder.append(string);
        }
        stringBuilder.append(SmtpProtocolConstants.CRLF);
        SmtpExchange smtpExchange = new SmtpExchange(new ArrayList<String>(this.readData), stringBuilder.toString());
        this.exchanges.add(smtpExchange);
        this.readData.clear();
        if (this.options.debugStream != null) {
            this.options.debugStream.println("< " + stringBuilder.toString().trim());
        }
        printWriter.print(stringBuilder.toString());
        printWriter.flush();
    }

    @FunctionalInterface
    public static interface MessageReceiver {
        public void receiveMessage(SmtpMessage var1);
    }

    private record InternalExchangeHandler(DefaultSmtpTransactionHandler sth) implements SmtpExchangeHandler
    {
        @Override
        public String nextLine() throws SmtpProtocolException {
            return this.sth.nextLine();
        }

        @Override
        public void reply(int n, String string) {
            this.sth.reply(n, string);
        }
    }
}

