/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.netcode;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.function.Supplier;

public final class RandomStringGenerator
implements Supplier<String> {
    private final SecureRandom random = new SecureRandom();
    private final int LENGTH;
    private final int SEED_LENGTH;

    public RandomStringGenerator(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length may not be negative");
        }
        this.LENGTH = length;
        this.SEED_LENGTH = (int)Math.ceil((float)length / 4.0f) * 3;
    }

    @Override
    public String get() {
        byte[] bytes;
        Base64.Encoder encoder;
        String candidate;
        do {
            bytes = new byte[this.SEED_LENGTH];
            this.random.nextBytes(bytes);
        } while ((candidate = (encoder = Base64.getUrlEncoder().withoutPadding()).encodeToString(bytes)).contains("_") || candidate.contains("-"));
        return candidate.substring(0, this.LENGTH);
    }
}

