/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.netcode;

import ch.awae.netcode.Channel;
import ch.awae.netcode.ChannelConfiguration;
import ch.awae.netcode.ChannelInformation;
import ch.awae.netcode.ConnectionException;
import ch.awae.netcode.InvalidAppIdException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;

final class ChannelManager {
    private final Predicate<String> appIdValidator;
    private final Supplier<String> channelIdProvider;
    private AtomicReference<ConcurrentHashMap<String, Channel>> channels = new AtomicReference(new ConcurrentHashMap());

    ChannelManager(Predicate<String> appIdValidator, Supplier<String> channelIdProvider) {
        this.appIdValidator = appIdValidator;
        this.channelIdProvider = channelIdProvider;
    }

    void closeAll() {
        ConcurrentHashMap oldMap = this.channels.getAndSet(new ConcurrentHashMap());
        oldMap.forEachValue(1000L, c -> {
            try {
                c.close();
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        });
    }

    Channel getChannel(String appId, String channelId) throws ConnectionException {
        if (!this.appIdValidator.test(appId)) {
            throw new InvalidAppIdException("invalid application id: '" + appId + "'");
        }
        return this.channels.get().get(appId + "/" + channelId);
    }

    Channel createChannel(String appId, ChannelConfiguration config, String creator) throws ConnectionException {
        Channel c;
        String id;
        if (!this.appIdValidator.test(appId)) {
            throw new InvalidAppIdException("invalid application id: '" + appId + "'");
        }
        do {
            id = this.channelIdProvider.get();
            config.setChannelId(id);
            c = new Channel(appId, config, this, creator);
        } while (this.channels.get().putIfAbsent(appId + "/" + id, c) != null);
        return c;
    }

    List<ChannelInformation> getPublicChannels(String appId) throws InvalidAppIdException {
        if (!this.appIdValidator.test(appId)) {
            throw new InvalidAppIdException("invalid application id: '" + appId + "'");
        }
        ArrayList<ChannelInformation> list = new ArrayList<ChannelInformation>();
        for (Map.Entry<String, Channel> entry : this.channels.get().entrySet()) {
            Channel c;
            ChannelInformation info;
            if (!entry.getKey().startsWith(appId) || !(info = (c = entry.getValue()).getInfo()).getConfiguration().isPublicChannel() || c.isFull()) continue;
            list.add(info);
        }
        return list;
    }

    void closeChannel(String appId, String channelId) throws IOException, InterruptedException {
        Channel channel = this.channels.get().remove(appId + "/" + channelId);
        if (channel != null) {
            channel.close();
        }
    }
}

