/*
 * Decompiled with CFR 0.152.
 */
package ch.bfh.due1.time.pojo;

import ch.bfh.due1.time.TimeSlot;
import java.time.LocalDateTime;

public class TimeSlotImpl
implements TimeSlot {
    private static final long serialVersionUID = -3193619080666868994L;
    private LocalDateTime start;
    private LocalDateTime finish;

    public TimeSlotImpl(LocalDateTime start, LocalDateTime finish) {
        if (start.isAfter(finish)) {
            throw new IllegalArgumentException("Finis time of time slot cannot be smaler than start time");
        }
        this.start = start;
        this.finish = finish;
    }

    @Override
    public LocalDateTime getFinish() {
        return this.finish;
    }

    @Override
    public LocalDateTime getStart() {
        return this.start;
    }

    @Override
    public boolean isEmpty() {
        return this.start.equals(this.finish);
    }

    @Override
    public boolean includes(LocalDateTime dateTime) {
        return !dateTime.isBefore(this.start) && !dateTime.isAfter(this.finish);
    }

    @Override
    public boolean includes(TimeSlot other) {
        return this.includes(other.getStart()) && this.includes(other.getFinish());
    }

    @Override
    public boolean overlaps(TimeSlot other) {
        return other.includes(this.start) || other.includes(this.finish) || this.includes(other);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TimeSlot)) {
            return false;
        }
        TimeSlot ts = (TimeSlot)other;
        return this.start.equals(ts.getStart()) && this.finish.equals(ts.getFinish());
    }

    public int hashCode() {
        int rval = 37;
        rval += 17 * this.start.hashCode();
        return rval += 17 * this.finish.hashCode();
    }

    @Override
    public int compareTo(TimeSlot other) {
        int rval = this.start.compareTo(other.getStart());
        if (rval == 0) {
            return this.finish.compareTo(other.getFinish());
        }
        return rval;
    }

    @Override
    public boolean startsBefore(TimeSlot other) {
        return this.getStart().isBefore(other.getStart());
    }

    @Override
    public boolean startsAfter(TimeSlot other) {
        return this.getStart().isAfter(other.getStart());
    }

    @Override
    public boolean endsBefore(TimeSlot other) {
        return this.getFinish().isBefore(other.getFinish());
    }

    @Override
    public boolean endsAfter(TimeSlot other) {
        return this.getFinish().isAfter(other.getFinish());
    }

    @Override
    public boolean strictlyIncludes(TimeSlot other) {
        return this.includes(other) && this.startsBefore(other) && this.endsAfter(other);
    }

    @Override
    public boolean exactlyMatches(TimeSlot other) {
        return this.includes(other) && !this.startsBefore(other) && !this.endsAfter(other);
    }
}

