/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import ch.bind.philib.validation.Validation;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class NamedSeqThreadFactory
implements ThreadFactory {
    private final AtomicLong SEQ = new AtomicLong(0L);
    private final String prefix;
    private final boolean daemon;
    private final ThreadGroup group;

    public NamedSeqThreadFactory(String name) {
        this(name, false, null);
    }

    public NamedSeqThreadFactory(String name, boolean daemon) {
        this(name, daemon, null);
    }

    public NamedSeqThreadFactory(String name, boolean daemon, ThreadGroup group) {
        Validation.notNull(name);
        this.prefix = name + "-";
        this.daemon = daemon;
        this.group = group;
    }

    @Override
    public Thread newThread(Runnable r) {
        if (r == null) {
            return null;
        }
        String name = this.prefix + this.SEQ.getAndIncrement();
        Thread t = new Thread(this.group, r, name);
        if (this.daemon) {
            t.setDaemon(true);
        }
        return t;
    }
}

